/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.domain.service.arverrec;

import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitescloud.cloudt.core.seq.SeqNumProvider;
import com.elitesland.fin.application.convert.arverrec.ArVerRecDtlConvert;
import com.elitesland.fin.domain.entity.arverrec.ArVerRecDO;
import com.elitesland.fin.domain.entity.arverrec.ArVerRecDtl;
import com.elitesland.fin.domain.entity.arverrec.ArVerRecDtlDO;
import com.elitesland.fin.domain.service.arverrec.ArVerRecDomainService;
import com.elitesland.fin.infr.dto.arverrec.ArVerRecDtlDTO;
import com.elitesland.fin.infr.repo.arverrec.ArVerRecDtlRepo;
import com.elitesland.fin.infr.repo.arverrec.ArVerRecDtlRepoProc;
import com.elitesland.fin.infr.repo.arverrec.ArVerRecRepo;
import com.elitesland.fin.infr.repo.arverrec.ArVerRecRepoProc;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ArVerRecDomainServiceImpl
implements ArVerRecDomainService {
    private final ArVerRecRepo arVerRecRepo;
    private final ArVerRecDtlRepo arVerRecDtlRepo;
    private final ArVerRecRepoProc arVerRecRepoProc;
    private final ArVerRecDtlRepoProc arVerRecDtlRepoProc;
    private final SeqNumProvider sysNumberRuleService;

    @Override
    public Boolean queryByScId(Long scId) {
        return this.arVerRecDtlRepoProc.queryByScId(scId);
    }

    @Override
    public Long save(List<ArVerRecDtl> arVerRecDtls) {
        BigDecimal apVerAmt = arVerRecDtls.stream().filter(t -> t.getOrderType().equals("AP")).map(ArVerRecDtl::getAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal payVerAmt = arVerRecDtls.stream().filter(t -> t.getOrderType().equals("PAY")).map(ArVerRecDtl::getAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
        String verNo = this.sysNumberRuleService.generateCode("yst-fin", "APVER", null);
        ArVerRecDO apVerRecDO = new ArVerRecDO();
        apVerRecDO.setArVerAmt(apVerAmt);
        apVerRecDO.setRecVerAmt(payVerAmt);
        apVerRecDO.setVerNo(verNo);
        ArVerRecDO save = (ArVerRecDO)this.arVerRecRepo.save(apVerRecDO);
        if (StringUtils.isEmpty((CharSequence)save.toString())) {
            throw new BusinessException(ApiCode.DAO_EXCEPTION, "\u4fdd\u5b58\u5e94\u6536\u6838\u9500\u8bb0\u5f55\u6c47\u603b\u8868\u5931\u8d25");
        }
        Long masId = save.getId();
        List<ArVerRecDtlDO> arVerRecDtlDOS = ArVerRecDtlConvert.INSTANCE.convertDOList(arVerRecDtls);
        arVerRecDtlDOS.forEach(t -> {
            t.setVerNo(verNo);
            t.setMasId(masId);
            t.setVerDate(LocalDateTime.now());
        });
        this.arVerRecDtlRepo.saveAll(arVerRecDtlDOS);
        return masId;
    }

    @Override
    public List<ArVerRecDtlDTO> queryDtlByMasIds(Collection<Long> masIds) {
        return this.arVerRecDtlRepoProc.queryDtlByMasIds(masIds);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long logicDelDtlByIds(Collection<Long> ids) {
        return this.arVerRecDtlRepoProc.logicDelByIds(ids);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long logicDelByIds(Collection<Long> ids, String userName, Long userId) {
        return this.arVerRecRepoProc.logicDelByIds(ids, userName, userId);
    }

    public ArVerRecDomainServiceImpl(ArVerRecRepo arVerRecRepo, ArVerRecDtlRepo arVerRecDtlRepo, ArVerRecRepoProc arVerRecRepoProc, ArVerRecDtlRepoProc arVerRecDtlRepoProc, SeqNumProvider sysNumberRuleService) {
        this.arVerRecRepo = arVerRecRepo;
        this.arVerRecDtlRepo = arVerRecDtlRepo;
        this.arVerRecRepoProc = arVerRecRepoProc;
        this.arVerRecDtlRepoProc = arVerRecDtlRepoProc;
        this.sysNumberRuleService = sysNumberRuleService;
    }
}

