/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.domain.service.paytype;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.BaseModel;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitesland.fin.application.convert.paytype.PayTypeOuConvert;
import com.elitesland.fin.domain.entity.paytype.PayTypeOu;
import com.elitesland.fin.domain.entity.paytype.PayTypeOuDO;
import com.elitesland.fin.domain.param.paytype.PayTypeOuPageParam;
import com.elitesland.fin.domain.service.paytype.PayTypeOuDomainService;
import com.elitesland.fin.infr.dto.paytype.PayTypeOuDTO;
import com.elitesland.fin.infr.repo.paytype.PayTypeOuRepo;
import com.elitesland.fin.infr.repo.paytype.PayTypeOuRepoProc;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PayTypeOuDomainServiceImpl
implements PayTypeOuDomainService {
    private final PayTypeOuRepo payTypeOuRepo;
    private final PayTypeOuRepoProc payTypeOuRepoProc;

    @Override
    public List<PayTypeOuDTO> queryByPayTypeIds(List<Long> payTypeIds) {
        return this.payTypeOuRepoProc.queryByPayTypeIds(payTypeIds);
    }

    @Override
    public PagingVO<PayTypeOuDTO> page(PayTypeOuPageParam param) {
        return this.payTypeOuRepoProc.page(param);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<Long> cancelOu(List<Long> ids) {
        this.payTypeOuRepoProc.deleteByIds(ids);
        return ids;
    }

    @Override
    public List<Long> queryByOuId(Long ouId) {
        return this.payTypeOuRepoProc.queryByOuId(ouId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<Long> addOu(List<PayTypeOu> payTypeOus) {
        payTypeOus.forEach(PayTypeOu::checkNotNull);
        if (CollUtil.isEmpty(payTypeOus)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5206\u914d\u516c\u53f8\u83b7\u53d6\u6570\u636e\u4e3a\u7a7a");
        }
        Long payTypeId = payTypeOus.get(0).getPayTypeId();
        List ids = this.payTypeOuRepoProc.queryByPayTypeIds(List.of(payTypeId)).stream().map(PayTypeOuDTO::getOuId).collect(Collectors.toList());
        List<PayTypeOu> needSave = payTypeOus.stream().filter(ou -> !ids.contains(ou.getOuId())).collect(Collectors.toList());
        List<PayTypeOuDO> typeOuDOS = PayTypeOuConvert.INSTANCE.convert(needSave);
        return this.payTypeOuRepo.saveAll(typeOuDOS).stream().map(BaseModel::getId).collect(Collectors.toList());
    }

    public PayTypeOuDomainServiceImpl(PayTypeOuRepo payTypeOuRepo, PayTypeOuRepoProc payTypeOuRepoProc) {
        this.payTypeOuRepo = payTypeOuRepo;
        this.payTypeOuRepoProc = payTypeOuRepoProc;
    }
}

