/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.domain.service.rectype;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.BaseModel;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitesland.fin.application.convert.rectype.RecTypeOuConvert;
import com.elitesland.fin.domain.entity.rectype.RecTypeOu;
import com.elitesland.fin.domain.entity.rectype.RecTypeOuDO;
import com.elitesland.fin.domain.param.rectype.RecTypeOuPageParam;
import com.elitesland.fin.domain.service.rectype.RecTypeOuDomainService;
import com.elitesland.fin.infr.dto.rectype.RecTypeOuDTO;
import com.elitesland.fin.infr.repo.rectype.RecTypeOuRepo;
import com.elitesland.fin.infr.repo.rectype.RecTypeOuRepoProc;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RecTypeOuDomainServiceImpl
implements RecTypeOuDomainService {
    private final RecTypeOuRepo recTypeOuRepo;
    private final RecTypeOuRepoProc reTypeOuRepoProc;

    @Override
    public PagingVO<RecTypeOuDTO> page(RecTypeOuPageParam param) {
        return this.reTypeOuRepoProc.page(param);
    }

    @Override
    public List<Long> queryByOuId(Long ouId) {
        return this.reTypeOuRepoProc.queryByOuId(ouId);
    }

    @Override
    public List<RecTypeOuDTO> queryByRecTypeIds(List<Long> recTypeId) {
        return this.reTypeOuRepoProc.queryByRecTypeIds(recTypeId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<Long> cancelOu(List<Long> ids) {
        this.reTypeOuRepoProc.deleteByIds(ids);
        return ids;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<Long> addOu(List<RecTypeOu> recTypeOus) {
        if (CollUtil.isEmpty(recTypeOus)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5206\u914d\u516c\u53f8\u83b7\u53d6\u6570\u636e\u4e3a\u7a7a");
        }
        recTypeOus.forEach(RecTypeOu::checkNotNull);
        Long payTypeId = recTypeOus.get(0).getRecTypeId();
        List ids = this.reTypeOuRepoProc.queryByRecTypeIds(List.of(payTypeId)).stream().map(RecTypeOuDTO::getOuId).collect(Collectors.toList());
        List<RecTypeOu> needSave = recTypeOus.stream().filter(ou -> !ids.contains(ou.getOuId())).collect(Collectors.toList());
        List<RecTypeOuDO> doList = RecTypeOuConvert.INSTANCE.convert(needSave);
        return this.recTypeOuRepo.saveAll(doList).stream().map(BaseModel::getId).collect(Collectors.toList());
    }

    public RecTypeOuDomainServiceImpl(RecTypeOuRepo recTypeOuRepo, RecTypeOuRepoProc reTypeOuRepoProc) {
        this.recTypeOuRepo = recTypeOuRepo;
        this.reTypeOuRepoProc = reTypeOuRepoProc;
    }
}

