/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.provider.workflow;

import com.elitescloud.cloudt.core.isolate.Isolatable;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitescloud.cloudt.tenant.config.support.TenantSession;
import com.elitesland.fin.application.service.workflow.WorkFlowDefKey;
import com.elitesland.fin.application.service.workflow.aporder.ApOrderProcessService;
import com.elitesland.fin.application.service.workflow.arorder.ArOrderProcessService;
import com.elitesland.fin.application.service.workflow.inputinv.InputInvProcessService;
import com.elitesland.fin.application.service.workflow.payorder.PayOrderProcessService;
import com.elitesland.fin.application.service.workflow.recorder.RecOrderProcessService;
import com.elitesland.fin.application.service.workflow.saleinv.SaleInvProcessService;
import com.elitesland.workflow.CommentInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import java.util.ArrayList;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FinWorkflowCallBack {
    private static final Logger log = LoggerFactory.getLogger(FinWorkflowCallBack.class);
    private final ApOrderProcessService apOrderProcessService;
    private final PayOrderProcessService payOrderProcessService;
    private final ArOrderProcessService arOrderProcessService;
    private final RecOrderProcessService recOrderProcessService;
    private final InputInvProcessService inputInvProcessService;
    private final SaleInvProcessService saleInvProcessService;
    private final Isolatable isolatable;

    public ArrayList<String> taskAssignee(String tenantId, String procDefKey, String taskKey, String businessKey, String customParams) {
        log.info("\u52a8\u6001\u6307\u5b9a\u4efb\u52a1\u8d1f\u8d23\u4eba: \u6d41\u7a0b\u5b9a\u4e49KEY:{},\u4efb\u52a1key:{},\u4e1a\u52a1key:{},\u81ea\u5b9a\u4e49\u53c2\u6570:{},\u79df\u6237ID:{}", new Object[]{procDefKey, taskKey, businessKey, customParams, tenantId});
        try {
            return (ArrayList)this.isolatable.apply(() -> this.getUserIds(procDefKey, businessKey, customParams), (Object)tenantId);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<String>();
        }
    }

    private ArrayList<String> getUserIds(String procDefKey, String businessKey, String customParams) {
        ArrayList<String> userIds = new ArrayList<String>();
        if (StringUtils.isNotEmpty((CharSequence)customParams)) {
            if (procDefKey.equals(WorkFlowDefKey.FIN_AP_ORDER.name())) {
                userIds = this.apOrderProcessService.taskAssignee(businessKey, customParams);
            }
            if (procDefKey.equals(WorkFlowDefKey.FIN_PAY_ORDER.name())) {
                userIds = this.payOrderProcessService.taskAssignee(businessKey, customParams);
            }
            if (procDefKey.equals(WorkFlowDefKey.FIN_REC_ORDER.name())) {
                userIds = this.recOrderProcessService.taskAssignee(businessKey, customParams);
            }
            if (procDefKey.equals(WorkFlowDefKey.FIN_SALE_INV.name())) {
                userIds = this.saleInvProcessService.taskAssignee(businessKey, customParams);
            }
            if (procDefKey.equals(WorkFlowDefKey.FIN_INPUT_INV.name())) {
                userIds = this.inputInvProcessService.taskAssignee(businessKey, customParams);
            }
            if (procDefKey.equals(WorkFlowDefKey.FIN_AR_ORDER.name())) {
                userIds = this.apOrderProcessService.taskAssignee(businessKey, customParams);
            }
        }
        SysTenantDTO sysTenantDTO = TenantSession.getCurrentTenant();
        log.info("\u52a8\u6001\u6307\u5b9a\u4efb\u52a1\u8d1f\u8d23\u4eba\u8fd4\u56de\u7ed3\u679c:{},\u79df\u6237\u4fe1\u606f:{}", userIds, (Object)sysTenantDTO);
        return userIds;
    }

    public void taskCreated(String tenantId, String procDefKey, String taskKey, String businessKey, Set<String> taskAssignees) {
        log.info("\u4efb\u52a1\u521b\u5efa\u540e\u56de\u8c03: \u6d41\u7a0b\u5b9a\u4e49KEY:{},\u4efb\u52a1key:{},\u4e1a\u52a1key:{},\u5904\u7406\u4eba:{}", new Object[]{procDefKey, taskKey, businessKey, taskAssignees});
    }

    public void taskCompleted(String tenantId, String procDefKey, String taskKey, String businessKey, String taskHandler) {
        log.info("\u4efb\u52a1\u5b8c\u6210\u540e\u56de\u8c03: \u6d41\u7a0b\u5b9a\u4e49KEY:{},\u4efb\u52a1key:{},\u4e1a\u52a1key:{}\uff0c\u4efb\u52a1\u5904\u7406\u4eba{}", new Object[]{procDefKey, taskKey, businessKey, taskHandler});
    }

    public void processStatusChange(String tenantId, String procDefKey, ProcInstStatus procInstStatus, String businessKey, CommentInfo commentInfo) {
        log.info("\u6d41\u7a0b\u56de\u8c03 procDefKey:" + procDefKey + " ,procInstStatus:" + procInstStatus + ",businessKey:" + businessKey + ",CommentInfo:" + commentInfo);
        if (procDefKey.equals(WorkFlowDefKey.FIN_AP_ORDER.name())) {
            this.apOrderProcessService.processStatusChange(this.getId(businessKey), procInstStatus, commentInfo);
        }
        if (procDefKey.equals(WorkFlowDefKey.FIN_AR_ORDER.name())) {
            this.arOrderProcessService.processStatusChange(this.getId(businessKey), procInstStatus, commentInfo);
        }
        if (procDefKey.equals(WorkFlowDefKey.FIN_REC_ORDER.name())) {
            this.recOrderProcessService.processStatusChange(this.getId(businessKey), procInstStatus, commentInfo);
        }
        if (procDefKey.equals(WorkFlowDefKey.FIN_PAY_ORDER.name())) {
            this.payOrderProcessService.processStatusChange(this.getId(businessKey), procInstStatus, commentInfo);
        }
        if (procDefKey.equals(WorkFlowDefKey.FIN_SALE_INV.name())) {
            this.saleInvProcessService.processStatusChange(this.getId(businessKey), procInstStatus, commentInfo);
        }
        if (procDefKey.equals(WorkFlowDefKey.FIN_INPUT_INV.name())) {
            this.inputInvProcessService.processStatusChange(this.getId(businessKey), procInstStatus, commentInfo);
        }
    }

    private Long getId(String businessKey) {
        return Long.valueOf(businessKey);
    }

    public FinWorkflowCallBack(ApOrderProcessService apOrderProcessService, PayOrderProcessService payOrderProcessService, ArOrderProcessService arOrderProcessService, RecOrderProcessService recOrderProcessService, InputInvProcessService inputInvProcessService, SaleInvProcessService saleInvProcessService, Isolatable isolatable) {
        this.apOrderProcessService = apOrderProcessService;
        this.payOrderProcessService = payOrderProcessService;
        this.arOrderProcessService = arOrderProcessService;
        this.recOrderProcessService = recOrderProcessService;
        this.inputInvProcessService = inputInvProcessService;
        this.saleInvProcessService = saleInvProcessService;
        this.isolatable = isolatable;
    }
}

