/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.repo.account;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.account.AccountPageParam;
import com.elitesland.fin.application.facade.param.account.AccountParam;
import com.elitesland.fin.application.facade.vo.account.AccountVO;
import com.elitesland.fin.entity.account.QAccountDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class AccountRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QAccountDO qAccountDO = QAccountDO.accountDO;

    public PagingVO<AccountVO> page(AccountPageParam accountPageParam) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (StringUtils.isNotBlank((CharSequence)accountPageParam.getAccType())) {
            predicates.add(this.qAccountDO.accType.eq((Object)accountPageParam.getAccType()));
        }
        if (StringUtils.isNotBlank((CharSequence)accountPageParam.getAccName())) {
            predicates.add(this.qAccountDO.accName.like("%" + accountPageParam.getAccName() + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)accountPageParam.getState())) {
            predicates.add(this.qAccountDO.state.eq((Object)accountPageParam.getState()));
        }
        JPAQuery query = (JPAQuery)this.select(AccountVO.class).where(ExpressionUtils.allOf(predicates));
        accountPageParam.setPaging(query);
        accountPageParam.fillOrders(query, this.qAccountDO);
        return PagingVO.builder().total((long)query.fetch().size()).records(query.fetch()).build();
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(cls, (Expression[])new Expression[]{this.qAccountDO.id, this.qAccountDO.accName, this.qAccountDO.accCode, this.qAccountDO.accType, this.qAccountDO.state, this.qAccountDO.createTime, this.qAccountDO.creator})).from((EntityPath)this.qAccountDO);
    }

    public Long updateState(AccountParam accountParam) {
        long res = this.jpaQueryFactory.update((EntityPath)this.qAccountDO).set((Path)this.qAccountDO.state, (Object)accountParam.getState()).where(new Predicate[]{this.qAccountDO.id.eq((Object)accountParam.getId())}).execute();
        return res;
    }

    public AccountRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

