package com.elitesland.interfaces.dto;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.system.dto.ThirdApiRetryParamDTO;
import lombok.Data;
import org.springframework.http.HttpMethod;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Map;

@Data
public class SyncResult implements Serializable {

    private String thirdApp;

    // 是否成功
    private Boolean success;

    // 响应内容
    private String resp;

    private String bussinessKey;

    private String request;

    /**
     * 是否请求成功
     */
    private Boolean reqSuccess;

    /**
     * 请求失败信息
     */
    private String reqFailMsg;

    /**
     * 请求时间
     */
    private LocalDateTime reqTime;

    /**
     * 请求头
     */
    private Map<String, String[]> reqHeaders;

    private HttpMethod reqMethod;

    /**
     * 请求的查询参数
     */
    private Map<String, String[]> reqQueryParams;

    @NotBlank(message = "请求的接口为空")
    private String uri;

    @NotNull(message = "Restful标识为空")
    private Boolean restful;

    private String serverAddr;

    private ThirdApiRetryParamDTO retryParamDTO;

    public static SyncResult success(String req, String resp, HttpMethod reqMethod, String serverAddr, String uri, Boolean restful, String thirdApp,
                                       Map<String, String[]> reqHeaders) {
        SyncResult result = new SyncResult();
        result.setResp(resp);
        result.setRequest(req);
        result.setSuccess(true);
        result.setReqSuccess(true);
        result.setReqTime(LocalDateTime.now());
        result.setReqMethod(reqMethod);
        result.setServerAddr(serverAddr);
        result.setUri(uri);
        result.setRestful(restful);
        result.setThirdApp(thirdApp);
        result.setReqHeaders(reqHeaders);
        return result;
    }

    public static SyncResult success(String req, String resp, HttpMethod reqMethod, String serverAddr, String uri, Boolean restful, String thirdApp,
                                     Map<String, String[]> reqHeaders, String bussinessKey) {
        SyncResult result = new SyncResult();
        result.setResp(resp);
        result.setRequest(req);
        result.setSuccess(true);
        result.setReqSuccess(true);
        result.setReqTime(LocalDateTime.now());
        result.setReqMethod(reqMethod);
        result.setServerAddr(serverAddr);
        result.setUri(uri);
        result.setRestful(restful);
        result.setThirdApp(thirdApp);
        result.setReqHeaders(reqHeaders);
        result.setBussinessKey(bussinessKey);
        return result;
    }

    public static SyncResult fail(String req, String resp, Boolean reqSuccess, String reqFailMsg, HttpMethod reqMethod, String serverAddr, String uri, Boolean restful, String thirdApp,
                                    Map<String, String[]> reqHeaders) {
        SyncResult result = new SyncResult();
        result.setResp(resp);
        result.setRequest(req);
        result.setSuccess(false);
        result.setReqSuccess(reqSuccess);
        result.setReqTime(LocalDateTime.now());
        result.setReqMethod(reqMethod);
        result.setServerAddr(serverAddr);
        result.setUri(uri);
        result.setRestful(restful);
        result.setThirdApp(thirdApp);
        result.setReqFailMsg(reqFailMsg);
        result.setReqHeaders(reqHeaders);
        return result;
    }

    public static SyncResult fail(String req, String resp, Boolean reqSuccess, String reqFailMsg, HttpMethod reqMethod, String serverAddr, String uri, Boolean restful, String thirdApp,
                                  Map<String, String[]> reqHeaders, String bussinessKey) {
        SyncResult result = new SyncResult();
        result.setResp(resp);
        result.setRequest(req);
        result.setSuccess(false);
        result.setReqSuccess(reqSuccess);
        result.setReqTime(LocalDateTime.now());
        result.setReqMethod(reqMethod);
        result.setServerAddr(serverAddr);
        result.setUri(uri);
        result.setRestful(restful);
        result.setThirdApp(thirdApp);
        result.setReqFailMsg(reqFailMsg);
        result.setReqHeaders(reqHeaders);
        result.setBussinessKey(bussinessKey);
        return result;
    }

    public String getData() {
        if (success == null || !success) {
            throw new BusinessException("失败：" + resp);
        }
        return resp;
    }
}
