package com.elitesland.sale.lm.rpc;

import com.elitesland.sale.api.vo.resp.crm.LmSaveCustRespVO;
import com.elitesland.sale.lm.Application;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(name = Application.NAME, path = LmCustRpcService.URI)
public interface LmCustRpcService {

    String URI = Application.URI_PREFIX + "/cust";


    @GetMapping("/getInvCustCode")
    List<String> getInvCustCodes(@RequestParam("userName") Long userId);


    @GetMapping("/findInvCust")
    List<LmSaveCustRespVO> findInvCust(@RequestParam("custCode") String custCode);

}
