package com.elitesland.sale.lm.rpc;

import com.elitesland.sale.api.vo.resp.crm.CrmCustSimpleVO;
import com.elitesland.sale.api.vo.resp.crm.LmSaveCustRespVO;
import com.elitesland.sale.lm.Application;
import com.elitesland.sale.lm.rpc.param.*;
import com.elitesland.sale.lm.rpc.param.query.CustAndBelongOuQueryDTO;
import com.elitesland.sale.lm.rpc.param.query.CustBaseQueryDTO;
import com.elitesland.sale.lm.rpc.param.query.PartnerInvQueryDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(name = Application.NAME, path = LmCustRpcService.URI)
public interface LmCustRpcService {

    String URI = Application.URI_PREFIX + "/cust";


    @GetMapping("/getInvCustCode")
    List<String> getInvCustCodes(@RequestParam("userName") Long userId);


    @GetMapping("/findInvCust")
    List<LmSaveCustRespVO> findInvCust(@RequestParam("custCode") String custCode);

    @GetMapping("/getCustSimple")
    CrmCustSimpleVO getCustSimple(@RequestParam("userName") String userName);

    @GetMapping("/getCustSimpleByUserId")
    CrmCustSimpleVO getCustSimpleByUserId(@RequestParam("userId") Long userId);

    @PostMapping("/getCustAndBelongOu")
    List<CustAndBelongOuDTO> getCustAndBelongOu(@RequestBody CustAndBelongOuQueryDTO custAndBelongOuQueryDTO);


    @GetMapping("/isCancelCustFlag")
    Boolean isCancelCustFlag(@RequestParam("custCode") String custCode);

    @GetMapping("/isDesExists")
    Boolean isDesExists(@RequestParam("desId")Long desId);

    @PostMapping("/getCustAgent")
    List<CustAgentInfoRpcDTO> getCustAgent(@RequestBody List<String> custCodes);


    @PostMapping("/getPartnerInvCust")
    List<PartnerInvRpcDTO> getPartnerInvCust(@RequestBody PartnerInvQueryDTO partnerInvQueryDTO);


    @PostMapping("/getCustAndAgent")
    List<CustAndAgentDTO> getCustAndAgent(@RequestBody CustBaseQueryDTO custBaseQueryDTO);

    @GetMapping("/querySalesmanStore")
    List<SalesmanStoreDTO> querySalesmanStore(@RequestParam("empCode") String empCode);

    @PostMapping("/queryType")
    List<CustBaseInfo> queryCustType(@RequestBody List<String> custCodes);

}
