package com.elitesland.sale.lm.rpc;

import com.elitesland.sale.lm.Application;
import com.elitesland.sale.lm.rpc.param.ProdOrderMatterDesRpcDTO;
import com.elitesland.sale.lm.rpc.param.VinOrderRpcDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(name = Application.NAME, path = VinOrderRpcService.URI)
public interface VinOrderRpcService {

    String URI = Application.URI_PREFIX + "/vin";


    /**
     * 既可以根据车架号查，也可以根据整车序列号查
     * @param vinNo
     * @return
     */
    @GetMapping("/getByVinNo")
    VinOrderRpcDTO getByVinNo(@RequestParam("vinNo") String vinNo);


    /**
     * 只根据车架号查询
     * @param vinNo
     * @return
     */
    @GetMapping("/getByPureVinNo")
    VinOrderRpcDTO getByPureVinNo(@RequestParam("vinNo") String vinNo);

    /**
     * 根据车架号查配件编码
     * @param vinNo
     * @return
     */
    @GetMapping("/getMatterCode")
    ProdOrderMatterDesRpcDTO getMatterCode(@RequestParam("vinNo") String vinNo);

}
