package com.elitesland.sale.lm.rpc.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * spu上架信息表DO
 *
 * @author : JS
 * @date : 2023-3-2
 */
@Data
@ApiModel(value = "spu上架信息表", description = "spu上架信息表")
public class ItmSpuPutawayRpcDTO implements Serializable {

    @ApiModelProperty("记录唯一ID")
    private Long id;
    /**
     * 商品SPU_ID
     */
    @ApiModelProperty(name = "商品SPU_ID")
    private Long spuId;

    /**
     * 发货基地
     */
    @ApiModelProperty(name = "发货基地")
    private Long desId;

    /**
     * 上架状态UDC：已上架/已下架
     */
    @ApiModelProperty(name = "上架状态UDC：已上架/已下架")
    private String putawayStatus;

    /**
     * 商品渠道类型:UDC
     */
    @ApiModelProperty(name = "商品渠道类型:UDC")
    private String channelType;

    @ApiModelProperty(value = "商品类型 [UDC]ITM:ITEM_TYPE2")
    private String itemType2;

    @ApiModelProperty(value = "spu编码")
    private String spuCode;

    @ApiModelProperty(value = "生产基地 [UDC]support:ORIGIN")
    private String origin;

    @ApiModelProperty(value = "整车类型 [UDC]ITM:ITEM_TYPE3")
    private String itemType3;

    @ApiModelProperty(value = "系列")
    private String itemGroup;

    @ApiModelProperty(value = "产品组 yst-supp:PRODUCT_TYPE")
    private String itemProduct;

    /**
     * sku上架信息
     */
    @ApiModelProperty(name = "sku上架信息")
    List<ItmSkuPutawayRpcDTO> skuList;

}