package com.elitesland.sale.lm.rpc.param;

import com.elitescloud.boot.common.convert.BooleanToIntegerConverter;
import com.elitesland.sale.api.vo.resp.crm.LmSaveCustRespVO;
import com.elitesland.sale.dto.CrmCustDTO;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Convert;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author : chen.niu
 * @description : 客户数据对象 RPC使用
 * @date : 2025-01-14 17:19
 */
@Data
public class LmCustExtRespDTO implements Serializable {
    private Long id;
    //@Column(name = "ou_id", columnDefinition = "bigint(18) default null  comment '公司ID 所属的公司'")
    private Long ouId;

    //@Column(name = "ou_code", columnDefinition = "longtext default null  comment '公司编号'")
    private String ouCode;

    //@Column(name = "ou_name", columnDefinition = "varchar(200) default null  comment '公司名称'")
    private String ouName;

    //@Column(name = "bu_id", columnDefinition = "bigint(18) default null  comment 'BUID'")
    private Long buId;

    //@Column(name = "bu_code", columnDefinition = "longtext default null  comment 'BU编号'")
    private String buCode;

    //@Column(name = "bu_name", columnDefinition = "varchar(200) default null  comment 'BU名称'")
    private String buName;

    //@Column(name = "cust_code", columnDefinition = "varchar(40) default null  comment '客户编号'")
    private String custCode;
    //@Column(name = "cust_code2", columnDefinition = "varchar(40) default null  comment '客户编号2'")
    private String custCode2;

    //@Column(name = "cust_name", columnDefinition = "varchar(200) default null  comment '客户名称'")
    private String custName;

    //@Column(name = "pid", columnDefinition = "varchar(255) default null  comment '父项客户号'")
    private String pid;

    //@Column(name = "cust_name2", columnDefinition = "varchar(200) default null  comment '客户名称2'")
    private String custName2;

    //@Column(name = "cust_name3", columnDefinition = "varchar(200) default null  comment '客户名称3'")
    private String custName3;

    //@Column(name = "cust_abbr", columnDefinition = "varchar(100) default null  comment '客户简称'")
    private String custAbbr;

    //@Column(name = "cust_desc", columnDefinition = "varchar(2000) default null  comment '客户描述'")
    private String custDesc;

    //@Column(name = "cust_type", columnDefinition = "varchar(40) default null  comment '客户类型 客户分类 [UDC]CRM:CUST_TYPE'")
    private String custType;

    //@Column(name = "cust_type2", columnDefinition = "varchar(40) default null  comment '客户类型2 客户归类 [UDC]CRM:CUST_TYPE2'")
    private String custType2;

    //@Column(name = "cust_status", columnDefinition = "varchar(40) default null  comment '客户状态 [UDC]CRM:CUST_STATUS'")
    private String custStatus;


    //@Column(name = "addr_no", columnDefinition = "bigint(18) default null  comment '地址号'")
    private Long addrNo;

    //@Column(name = "pinyin", columnDefinition = "varchar(800) default null  comment '拼音'")
    private String pinyin;

    //@Column(name = "pinyin_sh", columnDefinition = "varchar(200) default null  comment '拼音简称'")
    private String pinyinSh;

    //@Column(name = "agent_emp_id", columnDefinition = "bigint(18) default null  comment '业务员员工ID'")
    private Long agentEmpId;

    //@Column(name = "agent_emp_id2", columnDefinition = "bigint(18) default null  comment '上一个业务员'")
    private Long agentEmpId2;

    //@Column(name = "agent_emp_code", columnDefinition = "varchar(200) default null  comment '业务员编号'")
    private String agentEmpCode;

    //@Column(name = "cust_curr", columnDefinition = "varchar(40) default null  comment '币种'")
    private String custCurr;


    //@Column(name = "settle_type", columnDefinition = "varchar(40) default null  comment '结算方式'")
    private String settleType;


    //@Column(name = "region", columnDefinition = "varchar(40) default null  comment '区域 [UDC]SAL:SAL_REGION'")
    private String region;

    //@Column(name = "cust_level", columnDefinition = "varchar(40) default null  comment '客户等级 [UDC]CRM:CUST_LEVEL'")
    private String custLevel;

    //@Column(name = "province_code", columnDefinition = "varchar(40) default null  comment '省份代码'")
    private String provinceCode;

    //@Column(name = "channel_type", columnDefinition = "longtext default null  comment '渠道类型'")
    private String channelType;

    //@Column(name = "channel_type2", columnDefinition = "longtext default null  comment '渠道类型2'")
    private String channelType2;

    //@Column(name = "cust_industry", columnDefinition = "longtext default null  comment '客户行业'")
    private String custIndustry;

    //@Column(name = "vip_no", columnDefinition = "varchar(40) default null  comment '会员号码'")
    private String vipNo;

    //@Column(name = "vip_level", columnDefinition = "varchar(10) default null  comment '会员级别'")
    private String vipLevel;

    //@Column(name = "vip_group", columnDefinition = "varchar(20) default null  comment '会员组别'")
    private String vipGroup;

    //@Column(name = "vip_gender", columnDefinition = "longtext default null  comment '会员性别'")
    private String vipGender;

    //@Column(name = "vip_birth_date", columnDefinition = "datetime default null  comment '会员生日'")
    private LocalDateTime vipBirthDate;

    //@Column(name = "vip_job", columnDefinition = "longtext default null  comment '会员职业'")
    private String vipJob;

    //@Column(name = "cust_source", columnDefinition = "varchar(20) default null  comment '客户来源 [UDC]CRM:CUST_SOURCE'")
    private String custSource;

    //@Column(name = "valid_from", columnDefinition = "datetime default null  comment '生效日期'")
    private LocalDateTime validFrom;

    //@Column(name = "valid_to", columnDefinition = "datetime default null  comment '失效日期'")
    private LocalDateTime validTo;

    //@Column(name = "taxpayer_type", columnDefinition = "varchar(40) default null  comment '纳税人类型 [UDC]ORG:CUST_TAXER_TYPE'")
    private String taxpayerType;
    private String taxpayerTypeName;
    //@Column(name = "taxer_no", columnDefinition = "varchar(100) default null  comment '税号'")
    private String taxerNo;

    //@Column(name = "inv_type", columnDefinition = "varchar(40) default null  comment '发票类型 [UDC]COM:INV_TYPE'")
    private String invType;

    //@Column(name = "inv_title", columnDefinition = "varchar(40) default null  comment '开票抬头'")
    private String invTitle;

    //@Column(name = "inv_address", columnDefinition = "varchar(200) default null  comment '开票地址'")
    private String invAddress;

    //@Column(name = "inv_tel", columnDefinition = "longtext default null  comment '开票电话'")
    private String invTel;

    //@Column(name = "inv_pic_name", columnDefinition = "longtext default null  comment '开票联系人'")
    private String invPicName;

    //@Column(name = "inv_pic_phone", columnDefinition = "longtext default null  comment '开票联系人电话'")
    private String invPicPhone;

    //@Column(name = "inv_bank_name", columnDefinition = "longtext default null  comment '开票银行名称'")
    private String invBankName;

    //@Column(name = "inv_bank_branch", columnDefinition = "longtext default null  comment '开票银行支行'")
    private String invBankBranch;

    //@Column(name = "inv_bank_acc", columnDefinition = "longtext default null  comment '开票银行账号'")
    private String invBankAcc;

    //@Column(name = "tax_rate_no", columnDefinition = "longtext default null  comment '税率编号'")
    private String taxRateNo;

    //@Column(name = "tax_rate", columnDefinition = "decimal(20, 4) default null  comment '税率'")
    private BigDecimal taxRate;

    //@Column(name = "fin_gl_type", columnDefinition = "varchar(40) default null  comment '总账类型'")
    private String finGlType;

    //@Column(name = "ic_register_no", columnDefinition = "varchar(40) default null  comment '工商登记号'")
    private String icRegisterNo;

    //@Column(name = "register_date", columnDefinition = "datetime default null  comment '注册日期'")
    private LocalDateTime registerDate;

    //@Column(name = "register_address", columnDefinition = "varchar(200) default null  comment '注册地址'")
    private String registerAddress;

    //@Column(name = "register_trademark_no", columnDefinition = "varchar(40) default null  comment '注册商标编号'")
    private String registerTrademarkNo;

    //@Column(name = "register_fund", columnDefinition = "varchar(40) default null  comment '注册资金'")
    private String registerFund;

    //@Column(name = "register_fund_curry", columnDefinition = "varchar(40) default null  comment '注册资金货币'")
    private String registerFundCurry;

    //@Column(name = "ic_issued", columnDefinition = "varchar(40) default null  comment '工商登记注册机关'")
    private String icIssued;

    //@Column(name = "ic_issued_date", columnDefinition = "datetime default null  comment '工商登记日期'")
    private LocalDateTime icIssuedDate;

    //@Column(name = "biz_code_cert", columnDefinition = "varchar(40) default null  comment '组织机构代码证'")
    private String bizCodeCert;

    //@Column(name = "biz_type", columnDefinition = "varchar(40) default null  comment '机构类型'")
    private String bizType;

    //@Column(name = "biz_issued", columnDefinition = "varchar(40) default null  comment '组织机构代码证颁发单位'")
    private String bizIssued;

    //@Column(name = "cert_no", columnDefinition = "varchar(40) default null  comment '统一信用代码'")
    private String certNo;

    //@Column(name = "tax_reg_no", columnDefinition = "varchar(40) default null  comment '税务登记证编号'")
    private String taxRegNo;

    //@Column(name = "taxpayer_id", columnDefinition = "varchar(40) default null  comment '纳税人识别号'")
    private String taxpayerId;

    //@Column(name = "repr", columnDefinition = "varchar(40) default null  comment '法人代表'")
    private String repr;

    //@Column(name = "repr_cert_type", columnDefinition = "varchar(40) default null  comment '法人证件类型'")
    private String reprCertType;

    //@Column(name = "repr_cert_no", columnDefinition = "varchar(40) default null  comment '法人证件编号 C端用这个表时，存会员证件号'")
    private String reprCertNo;

    //@Column(name = "repr_cert_mobile", columnDefinition = "varchar(40) default null  comment '法人手机号'")
    private String reprCertMobile;

    //@Column(name = "comp_name", columnDefinition = "varchar(40) default null  comment '公司名称'")
    private String compName;

    //@Column(name = "comp_prop", columnDefinition = "varchar(40) default null  comment '公司性质'")
    private String compProp;

    //@Column(name = "comp_scale", columnDefinition = "varchar(40) default null  comment '公司规模'")
    private String compScale;

    //@Column(name = "comp_turnover", columnDefinition = "longtext default null  comment '年营业额'")
    private String compTurnover;

    //@Column(name = "comp_bussaddr", columnDefinition = "varchar(40) default null  comment '经营地点'")
    private String compBussaddr;

    //@Column(name = "comp_mainbuss", columnDefinition = "varchar(40) default null  comment '主营业务'")
    private String compMainbuss;

    //@Column(name = "comp_bussrange", columnDefinition = "varchar(2000) default null  comment '经营范围'")
    private String compBussrange;

    //@Column(name = "open_so_amt", columnDefinition = "decimal(20, 4) default null  comment '活动订单金额'")
    private BigDecimal openSoAmt;

    //@Column(name = "our_code", columnDefinition = "longtext default null  comment '我方在对方的编号'")
    private String ourCode;

    //@Column(name = "outer_code", columnDefinition = "varchar(20) default null  comment 'E1编码(外部客户编码)'")
    private String outerCode;

    //@Column(name = "intf_time", columnDefinition = "datetime default null  comment '接口处理时间'")
    private LocalDateTime intfTime;

    //@Column(name = "contact_phone", columnDefinition = "varchar(40) default null  comment '联系人电话'")
    private String contactPhone;

    //@Column(name = "contact_name", columnDefinition = "varchar(40) default null  comment '联系人姓名'")
    private String contactName;

    //@Column(name = "is_created_account", columnDefinition = "tinyint(1) comment '是否默认'")
    private Boolean isCreatedAccount;

    //@Column(name = "country", columnDefinition = "varchar(255) comment '国家'")
    private String country;

    //@Column(name = "cust_group", columnDefinition = "varchar(255) comment '客户组  UDC，开票客户、地址客户、其他'")
    private String custGroup;

    //@Column(name = "is_create_ou", columnDefinition = "int(10) default 0 comment '是否创建公司 0：否 1：是'")
    private Integer isCreateOu;


    //@Column(name = "cor_ou", columnDefinition = "varchar(255) comment '对应公司'")
    private String corOu;


    //@Column(name = "es1", columnDefinition = "varchar(40) default null  comment '其他1(同步生成公司 错误信息)'")
    private String es1;

    //@Column(name = "es2", columnDefinition = "tinyint(1) default 0  comment '是否开启四方交易'")
    private Boolean es2;

    //@Column(name = "es3", columnDefinition = "longtext default null  comment '其他3'")
    private String es3;

    //@Column(name = "es4", columnDefinition = "longtext default null  comment '其他4'")
    private String es4;

    //@Column(name = "es5", columnDefinition = "longtext default null  comment '其他5'")
    private String es5;

    //@Column(name = "es6", columnDefinition = "longtext default null  comment '其他6'")
    private String es6;

    //@Column(name = "es7", columnDefinition = "longtext default null  comment '其他7'")
    private String es7;

    //@Column(name = "legal_repre", columnDefinition = "varchar(200) default null  comment '法人代表'")
    private String legalRepre;


    //@Column(name = "cancel_cust_flag", columnDefinition = "tinyint(1)  comment '是否取消客户'")
    private Boolean cancelCustFlag;

    //@Column(name = "business_type_cust", columnDefinition = "varchar(200) default null  comment '业务类型UDC[yst-sale:BUSINESS_TYPE]'")
    private String businessTypeCust;

    //@Column(name = "auto_credit_flag", columnDefinition = "tinyint(1)  comment '是否自动授信客户'")
    private Boolean autoCreditFlag;

    //@Column(name = "auto_credit_flag_accessory", columnDefinition = "tinyint(1)  comment '是否配件自动授信客户'")
    private Boolean autoCreditFlagAccessory;

    //@Column(name = "store_order_flag", columnDefinition = "tinyint(1)  comment '是否开启门店下单'")
    private Boolean storeOrderFlag;

    //@Column(name = "city_code", columnDefinition = "varchar(40) default null  comment '城市编码'")
    private String cityCode;

    //@Column(name = "provincial_code", columnDefinition = "varchar(40) default null  comment '区域编码'")
    private String provincialCode;

    //@Column(name = "rebate_usage_ratio", columnDefinition = "decimal(10,6) default null  comment '返利使用比例'")
    private BigDecimal rebateUsageRatio;

    //@Column(name = "rebate_usage_ratio_accessory", columnDefinition = "decimal(10,6) default null  comment '配件返利使用比例'")
    private BigDecimal rebateUsageRatioAccessory;

    //@Column(name = "fglf", columnDefinition = "tinyint(1) comment '是否关联方'")
    private Boolean fglf;

}
