package com.elitesland.sale.lm.rpc.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * @author RYH
 * @date 2024/5/13
 */
@Data
@ApiModel("门店订单发货明细参数")
public class StoreOrderDoDtlRpcDTO {

    @ApiModelProperty("商品id")
    @NotNull(message = "商品id不能为空")
    private Long itemId;

    @ApiModelProperty("商品编码")
    @NotBlank(message = "商品编码不能为空")
    private String itemCode;

    @ApiModelProperty("发货数量")
    @NotNull(message = "发货数量不能为空")
    private BigDecimal shippedQty;
}
