package com.elitesland.market.service.recipe;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.market.MarketApplication;
import com.elitesland.market.dto.recipe.MktRecipeDTO;
import com.elitesland.market.param.MktRecipeParamDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

@FeignClient(name = MarketApplication.NAME, path = MarketApplication.PATH + MktRecipeRpcService.PATH)
@Validated
public interface MktRecipeRpcService {
    String PATH = "/recipe";

    @PostMapping("/getPurchasedRecipeList")
    ApiResult<List<MktRecipeDTO>> getPurchasedRecipeList(@RequestBody String mobile);

    @PostMapping("/getRecipeList")
    ApiResult<List<MktRecipeDTO>> getRecipeList(@RequestBody String mobile);

    @PostMapping("/findByParam")
    ApiResult<List<MktRecipeDTO>> findByParam(@RequestBody MktRecipeParamDTO paramDTO);
}
