package com.elitesland.market.service.sp;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.market.MarketApplication;
import com.elitesland.market.dto.sp.MktServicePackageCartDTO;
import com.elitesland.market.dto.sp.MktServicePackageDTO;
import com.elitesland.market.param.MktServicePackageOrderParamDTO;
import com.elitesland.market.param.MktServicePackageParamDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

@FeignClient(name = MarketApplication.NAME, path = MarketApplication.PATH + MktServicePackageRpcService.PATH)
@Validated
public interface MktServicePackageRpcService {
    String PATH = "/sp";

    @PostMapping("/getByParam")
    ApiResult<MktServicePackageDTO> getServicePackage(@RequestBody MktServicePackageParamDTO paramVO);

    @PostMapping("/updateApplyStatus")
    ApiResult<Object> updateSpApplyStatus(@RequestBody MktServicePackageOrderParamDTO paramVO);

    @PostMapping("/findCartsBySpId")
    ApiResult<List<MktServicePackageCartDTO>> findCartsBySpId(@RequestBody MktServicePackageParamDTO paramVO);
}


