package com.elitesland.market.dto.store;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

@Data
@ApiModel("demo入参")
public class MktStoreSyncDTO implements Serializable {
    private static final long serialVersionUID = 2489505151245139428L;

    private String storeName;

    private String storeCode;

    private String managerPhone;

    private String joinMode;

    private String storeType;

    private String brand;

    private String telephone;

    private String addr;

    private String storePhoto;

    private BigDecimal monthlyRent;

    private BigDecimal salary;

    private BigDecimal utilitiesFee;

    @ApiModelProperty("纬度")
    private String latitude;

    @ApiModelProperty("经度")
    private String longitude;

    @ApiModelProperty("是否统管")
    private Boolean unifiedManagementFlag;

    @ApiModelProperty("订货人")
    private String addresseeName;

    @ApiModelProperty("手机号")
    private String addresseeMobile;

    @ApiModelProperty("收件省市区")
    private String addresseeArea;

    @ApiModelProperty("订货地址")
    private String addresseeAddress;

    @ApiModelProperty("管理督导")
    private String glSupervision;

    @ApiModelProperty("大区")
    private String region;

    private List<MktStoreMobileSyncDTO> storeMobiles;

}
