package com.elitesland.market.service.store;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.market.MarketApplication;
import com.elitesland.market.dto.store.MktStoreDTO;
import com.elitesland.market.dto.store.MktStoreSyncDTO;
import com.elitesland.market.param.MktStoreNearbyParamDTO;
import com.elitesland.market.param.MktStorePageParamDTO;
import com.elitesland.market.param.MktStoreParamVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

@FeignClient(name = MarketApplication.NAME, path = MarketApplication.PATH + MktStoreRpcService.PATH)
@Validated
public interface MktStoreRpcService {
    String PATH = "/store";

    /**
     * 同步门店信息¬
     *
     * @param storeSyncDTOS 入参
     * @return 结果
     */
    @PostMapping("/save")
    ApiResult<List<Long>> syncStore(@RequestBody List<MktStoreSyncDTO> storeSyncDTOS);

    /**
     * 更新门店信息
     *
     * @param storeSyncDTOS
     * @return
     */
    @PostMapping("/update")
    ApiResult<List<Long>> updateStore(@RequestBody List<MktStoreSyncDTO> storeSyncDTOS);

    /**
     * 获取门店列表
     *
     * @param paramVO
     * @return
     */
    @PostMapping("/getStoreList")
    ApiResult<List<MktStoreDTO>> getStoreList(@RequestBody MktStoreParamVO paramVO);

    /**
     * 批量更新门店用户信息
     *
     * @param storeSyncDTOS
     * @return
     */
    @PostMapping("/updateStoreUser")
    ApiResult<Object> updateStoreUser(@RequestBody List<MktStoreSyncDTO> storeSyncDTOS);

    /**
     * 门店分页
     *
     * @param paramVO
     * @return
     */
    @PostMapping("/page")
    ApiResult<PagingVO<MktStoreDTO>> page(@RequestBody MktStorePageParamDTO paramVO);

    /**
     * 获取附近门店
     *
     * @param paramVO
     * @return
     */
    @PostMapping("/getNearbyStores")
    ApiResult<List<MktStoreDTO>> getNearbyStores(@RequestBody MktStoreNearbyParamDTO paramVO);

}


