package com.elitesland.market.service.sp;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.market.MarketApplication;
import com.elitesland.market.dto.sp.MktServicePackageCartDTO;
import com.elitesland.market.dto.sp.MktServicePackageDTO;
import com.elitesland.market.dto.sp.MktServicePackageSimpleDTO;
import com.elitesland.market.param.*;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

@FeignClient(name = MarketApplication.NAME, path = MarketApplication.PATH + MktServicePackageRpcService.PATH)
@Validated
public interface MktServicePackageRpcService {
    String PATH = "/sp";

    @PostMapping("/getByParam")
    ApiResult<MktServicePackageDTO> getServicePackage(@RequestBody MktServicePackageParamDTO paramVO);

    @PostMapping("/updateApplyStatus")
    ApiResult<Object> updateSpApplyStatus(@RequestBody MktServicePackageOrderParamDTO paramVO);

    @PostMapping("/findCartsBySpId")
    ApiResult<List<MktServicePackageCartDTO>> findCartsBySpId(@RequestBody MktServicePackageParamDTO paramVO);

    @PostMapping("/checkCanExecuteSp")
    ApiResult<List<MktServicePackageSimpleDTO>> checkCanExecuteSp(@RequestBody MktServicePackageExecuteParamDTO packageExecuteParamDTO);

    @PostMapping("/updateSendNoticeFlag")
    ApiResult<Object> updateSendNoticeFlag(@RequestBody MktServicePackageParamDTO paramVO);

    @PostMapping("/updateApplyCount")
    ApiResult<Object> updateApplyCount(@RequestBody MktServicePackageCountParamDTO paramVO);

    @PostMapping("/getSpList")
    ApiResult<List<MktServicePackageSimpleDTO>> getSpList(@RequestBody MktServicePackageParamDTO paramVO);

    @PostMapping("/recommendList")
    ApiResult<List<MktServicePackageSimpleDTO>> recommendList(@RequestBody MktServicePackageRecommendParamDTO paramVO);

    @PostMapping("/updateMaxSaleGrowthRatio")
    ApiResult<Object> updateMaxSaleGrowthRatio(@RequestBody List<MktServicePackageGrowthRatioParamDTO> paramDTOS);
}


