package com.elitesland.market.enums;

public enum MarketUdcEnum {

    RTS_APPLY_STATUS_DR("yst-market", "RTS_APPLY_STATUS", "菜品配方试销申请状态", "DR", "草稿"),
    RTS_APPLY_STATUS_APPRING("yst-market", "RTS_APPLY_STATUS", "菜品配方试销申请状态", "APPRING", "审批中"),
    RTS_APPLY_STATUS_CL("yst-market", "RTS_APPLY_STATUS", "菜品配方试销申请状态", "CL", "已取消"),
    RTS_APPLY_STATUS_REJECTED("yst-market", "RTS_APPLY_STATUS", "菜品配方试销申请状态", "REJECTED", "审批拒绝"),
    RTS_APPLY_STATUS_DONE("yst-market", "RTS_APPLY_STATUS", "菜品配方试销申请状态", "DONE", "已完成"),

    RR_APPLY_STATUS_DR("yst-market", "RR_APPLY_STATUS", "菜品配方发布申请状态", "DR", "草稿"),
    RR_APPLY_STATUS_APPRING("yst-market", "RR_APPLY_STATUS", "菜品配方发布申请状态", "APPRING", "审批中"),
    RR_APPLY_STATUS_CL("yst-market", "RR_APPLY_STATUS", "菜品配方发布申请状态", "CL", "已取消"),
    RR_APPLY_STATUS_REJECTED("yst-market", "RR_APPLY_STATUS", "菜品配方发布申请状态", "REJECTED", "审批拒绝"),
    RR_APPLY_STATUS_DONE("yst-market", "RR_APPLY_STATUS", "菜品配方发布申请状态", "DONE", "已完成"),

    DEV_TYPE_HQ("yst-market", "DEV_TYPE", "开发者类型", "HQ", "总部"),

    RO_STATUS_DR("yst-market", "RO_STATUS", "菜品订单状态", "DR", "草稿"),
    RO_STATUS_DONE("yst-market", "RO_STATUS", "菜品订单状态", "DONE", "已完成"),
    RO_STATUS_PAYING("yst-market", "RO_STATUS", "菜品订单状态", "PAYING", "支付中"),

    RO_STATUS_CLOSED("yst-market", "RO_STATUS", "菜品订单状态", "CLOSED", "已关闭"),

    ON_SHELF_APPLY_STATUS_DR("yst-market", "ON_SHELF_APPLY_STATUS", "菜品配方上架申请状态", "DR", "草稿"),
    ON_SHELF_APPLY_STATUS_APPRING("yst-market", "ON_SHELF_APPLY_STATUS", "菜品配方上架申请状态", "APPRING", "审批中"),
    ON_SHELF_APPLY_STATUS_CL("yst-market", "ON_SHELF_APPLY_STATUS", "菜品配方上架申请状态", "CL", "已取消"),
    ON_SHELF_APPLY_STATUS_REJECTED("yst-market", "ON_SHELF_APPLY_STATUS", "菜品配方上架申请状态", "REJECTED", "审批拒绝"),
    ON_SHELF_APPLY_STATUS_DONE("yst-market", "ON_SHELF_APPLY_STATUS", "菜品配方上架申请状态", "DONE", "已完成"),

    PAY_STATUS_UNPAID("yst-market", "PAY_STATUS", "支付状态", "UNPAID", "未支付"),
    PAY_STATUS_PAYING("yst-market", "PAY_STATUS", "支付状态", "PAYING", "支付中"),
    PAY_STATUS_PAID("yst-market", "PAY_STATUS", "支付状态", "PAID", "已支付"),

    RECIPE_TYPE_RECIPE("yst-market", "RECIPE_TYPE", "菜品配方类型", "RECIPE", "菜品配方"),
    RECIPE_TYPE_NOTE("yst-market", "RECIPE_TYPE", "菜品配方类型", "NOTE", "文章"),
    RECIPE_TYPE_SP("yst-market", "RECIPE_TYPE", "菜品配方类型", "SP", "服务包"),

    TRANSACTION_CLS_INCOME("yst-market", "TRANSACTION_CLS", "交易分类", "INCOME", "收益"),

    TRANSACTION_CLS_WITHDRAW("yst-market", "TRANSACTION_CLS", "交易分类", "WITHDRAW", "提现"),

    SOURCE_TYPE_ORDER("yst-market", "SOURCE_TYPE", "来源单据", "ORDER", "销售订单"),
    SOURCE_TYPE_SP("yst-market", "SOURCE_TYPE", "来源单据", "SP", "服务包订单"),

    SOURCE_TYPE_WITHDRAW("yst-market", "SOURCE_TYPE", "来源单据", "WITHDRAW", "提现申请单"),

    RTS_APPLY_DOC_TYPE_C("yst-market", "RTS_APPLY_DOC_TYPE", "菜品配方试销申请类型", "C", "新增申请单"),
    RTS_APPLY_DOC_TYPE_U("yst-market", "RTS_APPLY_DOC_TYPE", "菜品配方试销申请类型", "U", "变更申请单"),

    USER_EXTRACT_STATUS_DR("yst-market", "USER_EXTRACT_STATUS", "提现申请状态", "DR", "草稿"),
    USER_EXTRACT_STATUS_APPRING("yst-market", "USER_EXTRACT_STATUS", "提现申请状态", "APPRING", "审批中"),
    USER_EXTRACT_STATUS_CL("yst-market", "USER_EXTRACT_STATUS", "提现申请状态", "CL", "已取消"),
    USER_EXTRACT_STATUS_REJECTED("yst-market", "USER_EXTRACT_STATUS", "提现申请状态", "REJECTED", "审批拒绝"),
    USER_EXTRACT_STATUS_DONE("yst-market", "USER_EXTRACT_STATUS", "提现申请状态", "DONE", "已完成"),

    PAY_METHOD_BALANCE("yst-market", "PAY_METHOD", "菜品订单付款方式", "BALANCE", "余额支付"),
    PAY_METHOD_WECHAT("yst-market", "PAY_METHOD", "菜品订单付款方式", "WECHAT", "微信支付"),
    PAY_METHOD_ZERO("yst-market", "PAY_METHOD", "菜品订单付款方式", "ZERO", "零元支付"),

    TOPIC_SOURCE_NOTE("yst-market", "TOPIC_SOURCE", "专题来源", "NOTE", "文章"),
    TOPIC_SOURCE_RECIPE("yst-market", "TOPIC_SOURCE", "专题来源", "RECIPE", "配方"),
    TOPIC_SOURCE_DEVELOPER("yst-market", "TOPIC_SOURCE", "专题来源", "DEVELOPER", "开发者"),
    TOPIC_SOURCE_SP("yst-market", "TOPIC_SOURCE", "专题来源", "SP", "服务包"),

    SALE_METHOD_HQ_BUYOUT("yst-market", "SALE_METHOD", "售卖方式", "HQ_BUYOUT", "总部买断"),
    SALE_METHOD_EXTRACT("yst-market", "SALE_METHOD", "售卖方式", "EXTRACT", "提现"),
    SOURCE_WECHAT_MINI_APP("yst-market", "SYS_SOURCE_TYPE", "来源", "WECHAT_MINI_APP", "微信小程序"),

    USAGE_TYPE_PAYMENT("yst-market", "USAGE_TYPE", "用途", "PAYMENT", "付款"),
    USAGE_TYPE_CBK("yst-market", "USAGE_TYPE", "用途", "CBK", "CBK账户"),
    NT_STATUS_DR("yst-market", "NT_STATUS", "笔记状态", "DR", "草稿"),
    NT_STATUS_APPRING("yst-market", "NT_STATUS", "笔记状态", "APPRING", "审批中"),
    NT_STATUS_REJECTED("yst-market", "NT_STATUS", "笔记状态", "REJECTED", "审批拒绝"),
    NT_STATUS_DONE("yst-market", "NT_STATUS", "笔记状态", "DONE", "已完成"),

    DISTRIBUTION_STATUS_DR("yst-market", "DISTRIBUTION_STATUS", "分账状态", "DR", "待分账"),
    DISTRIBUTION_STATUS_NONE("yst-market", "DISTRIBUTION_STATUS", "分账状态", "NONE", "无需分账"),
    DISTRIBUTION_STATUS_DSTING("yst-market", "DISTRIBUTION_STATUS", "分账状态", "DSTING", "分账中"),
    DISTRIBUTION_STATUS_DONE("yst-market", "DISTRIBUTION_STATUS", "分账状态", "DONE", "分账完成"),
    DISTRIBUTION_STATUS_ERROR("yst-market", "DISTRIBUTION_STATUS", "分账状态", "ERROR", "分账失败"),
    MATERIAL_PURCHASE_APPLY_STATUS_NO_DELIVERY("yst-market", "MATERIAL_PURCHASE_APPLY_STATUS", "原料购买状态", "NO_DELIVERY", "未发货"),
    MATERIAL_PURCHASE_APPLY_STATUS_DONE("yst-market", "MATERIAL_PURCHASE_APPLY_STATUS", "原料购买状态", "DONE", "已发货"),

    POS_ONSHELF_STATUS_DONE("yst-market", "POS_ONSHELF_STATUS", "POS上架状态", "DONE", "已上架"),
    POS_ONSHELF_STATUS_DOING("yst-market", "POS_ONSHELF_STATUS", "POS上架状态", "DOING", "上架中"),
    POS_ONSHELF_STATUS_ERROR("yst-market", "POS_ONSHELF_STATUS", "POS上架状态", "ERROR", "上架失败"),

    SP_APPLY_STATUS_DR("yst-market", "SP_APPLY_STATUS", "服务包申请状态", "DR", "草稿"),
    SP_APPLY_STATUS_APPRING("yst-market", "SP_APPLY_STATUS", "服务包申请状态", "APPRING", "审批中"),
    SP_APPLY_STATUS_CL("yst-market", "SP_APPLY_STATUS", "服务包申请状态", "CL", "已取消"),
    SP_APPLY_STATUS_REJECTED("yst-market", "SP_APPLY_STATUS", "服务包申请状态", "REJECTED", "审批拒绝"),
    SP_APPLY_STATUS_DONE("yst-market", "SP_APPLY_STATUS", "服务包申请状态", "DONE", "已完成"),

    ACTIVITY_TYPE_INFO_SCREEN("yst-market", "ACTIVITY_TYPE", "活动营销类型", "INFO_SCREEN", "信发屏幕"),
    ACTIVITY_TYPE_MP_POPUP("yst-market", "ACTIVITY_TYPE", "活动营销类型", "MP_POPUP", "微信小程序弹窗"),
    ACTIVITY_TYPE_MP_TOP("yst-market", "ACTIVITY_TYPE", "活动营销类型", "MP_TOP", "小程序置顶"),
    ACTIVITY_TYPE_TODAY_RECOMMEND("yst-market", "ACTIVITY_TYPE", "活动营销类型", "TODAY_RECOMMEND", "今日推荐"),
    ACTIVITY_TYPE_MP_POPUP_FLOAT("yst-market", "ACTIVITY_TYPE", "活动营销类型", "MP_POPUP_FLOAT", "微信小程序浮层广告"),
    ACTIVITY_TYPE_MP_POPUP_SWIPER("yst-market", "ACTIVITY_TYPE", "活动营销类型", "MP_POPUP_SWIPER", "微信小程序轮播广告"),
    ACTIVITY_TYPE_MP_POPUP_FLOAT_ZFB("yst-market", "ACTIVITY_TYPE", "活动营销类型", "MP_POPUP_FLOAT_ZFB", "支付宝小程序浮层广告"),
    ACTIVITY_TYPE_MP_POPUP_SWIPER_ZFB("yst-market", "ACTIVITY_TYPE", "活动营销类型", "MP_POPUP_SWIPER_ZFB", "支付宝小程序轮播广告"),
    ACTIVITY_TYPE_MP_POPUP_ZFB("yst-market", "ACTIVITY_TYPE", "活动营销类型", "MP_POPUP_ZFB", "支付宝小程序弹窗"),
    ACTIVITY_TYPE_POS_ACTIVITY("yst-market", "ACTIVITY_TYPE", "活动营销类型", "POS_ACTIVITY", "营销活动"),
    ACTIVITY_TYPE_POS_COUPON("yst-market", "ACTIVITY_TYPE", "活动营销类型", "POS_COUPON", "优惠券"),
    ACTIVITY_TYPE_AD_MACHINE("yst-market", "ACTIVITY_TYPE", "活动营销类型", "AD_MACHINE", "广告机"),
    WMTG_TYPE_DYTG("yst-market", "WMTG_TYPE", "活动营销类型", "DYTG", "抖音团购"),
    WMTG_TYPE_ELE("yst-market", "WMTG_TYPE", "活动营销类型", "ELE", "饿了么"),
    WMTG_TYPE_JDWM("yst-market", "WMTG_TYPE", "活动营销类型", "JDWM", "京东外卖"),
    WMTG_TYPE_KSTG("yst-market", "WMTG_TYPE", "活动营销类型", "KSTG", "快手团购"),
    WMTG_TYPE_MTTG("yst-market", "WMTG_TYPE", "活动营销类型", "MTTG", "美团团购"),
    WMTG_TYPE_MTWM("yst-market", "WMTG_TYPE", "活动营销类型", "MTWM", "美团外卖"),


    FWO_STATUS_DR("yst-market", "FWO_STATUS", "免费试样工单状态", "DR", "草稿"),
    FWO_STATUS_CONFIRM("yst-market", "FWO_STATUS", "免费试样工单状态", "CONFIRM", "已确认"),

    FWO_SHIPMENT_STATUS_PENDING("yst-market", "FWO_SHIPMENT_STATUS", "免费试样工单发货状态", "PENDING", "待发货"),
    FWO_SHIPMENT_STATUS_SHIPPED("yst-market", "FWO_SHIPMENT_STATUS", "免费试样工单发货状态", "SHIPPED", "已发货"),

    FWO_SHIPMENT_STATUS_CONFIRM("yst-market", "FWO_SHIPMENT_STATUS", "免费试样工单发货状态", "RECEIVED", "已收货"),

    SPA_STATUS_DR("yst-market", "SPA_STATUS", "服务包审核状态", "DR", "草稿"),
    SPA_STATUS_APPROVED("yst-market", "SPA_STATUS", "服务包审核状态", "APPROVED", "审核通过"),
    SPA_STATUS_APPROVING("yst-market", "SPA_STATUS", "服务包审核状态", "APPROVING", "审核中"),

    SPA_STATUS_REJECTED("yst-market", "SPA_STATUS", "服务包审核状态", "REJECTED", "拒绝"),

    WO_STATUS_NOT_IN_STORE("yst-market", "WO_STATUS", "工单状态", "NOT_IN_STORE", "未到店"),
    WO_STATUS_IN_STORE("yst-market", "WO_STATUS", "工单状态", "IN_STORE", "到店"),
    ;
    private final String model;
    private final String code;
    private final String codeName;
    private final String valueCode;
    private final String valueCodeName;

    MarketUdcEnum(final String model, final String code, final String codeName, final String valueCode, final String valueCodeName) {
        this.model = model;
        this.code = code;
        this.codeName = codeName;
        this.valueCode = valueCode;
        this.valueCodeName = valueCodeName;
    }

    public String getValueCodeName() {
        return valueCodeName;
    }

    public String getValueCode() {
        return valueCode;
    }

    public String getMsg() {
        return valueCodeName;
    }

    public String getModel() {
        return model;
    }

    public String getCode() {
        return code;
    }

    public String getCodeName() {
        return codeName;
    }

    // 根据valueCode获取
    public static String getByValueCode(String code, String valueCode) {
        for (MarketUdcEnum value : MarketUdcEnum.values()) {
            if (value.getValueCode().equals(valueCode) && value.getCode().equals(code)) {
                return value.getValueCodeName();
            }
        }
        return null;
    }
}
