package com.elitesland.market.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.*;
import java.io.Serializable;

@Data
@ApiModel("附近门店查询入参")
public class MktStoreNearbyParamDTO implements Serializable {

    private static final long serialVersionUID = 18288788222L;

    @ApiModelProperty(value = "门店编码", required = true, example = "STORE001")
    @NotBlank(message = "门店编码不能为空")
    private String storeCode;

    @ApiModelProperty(value = "搜索半径（公里）", example = "5.0", notes = "默认5公里，最大50公里")
    @DecimalMin(value = "0.1", message = "搜索半径不能小于0.1公里")
    @DecimalMax(value = "50.0", message = "搜索半径不能大于50公里")
    private Double radiusKm = 5.0;

    @ApiModelProperty(value = "返回数量限制")
    private Integer limit = 20;
}
