package com.elitesland.yst.lm.order.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.lm.order.Application;
import com.elitesland.yst.lm.order.rpc.param.LmAfterSaleTimeParam;
import com.elitesland.yst.lm.order.rpc.param.resp.LmVehicleNoTimeDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.time.LocalDateTime;
import java.util.List;

@FeignClient(name = Application.NAME, path = LmVehicleNoRpcService.URI)
@Validated
public interface LmVehicleNoRpcService {
    String URI = "/lm/vehicleNoRpc";

    @GetMapping(value = "/getDocTimeByVehicle")
    LmVehicleNoTimeDTO getDocTimeByVehicle(@RequestParam(value = "vehicleNo") String vehicleNo);

    @PostMapping(value = "/getDocTimeByListVehicles")
    ApiResult<List<LmVehicleNoTimeDTO>> getDocTimeByListVehicles(@RequestBody LmAfterSaleTimeParam param);
}
