package com.elitesland.yst.lm.order.rpc.param.resp;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @Author: ryan.xu
 * @since 2023/3/25
 */
@Data
@ApiModel("发货单明细返回实体")
public class LmSalDoDRespDTO implements Serializable {
    private static final long serialVersionUID = -5699023872975414950L;

    @ApiModelProperty("发运基地ID")
    private Long desId;

    @ApiModelProperty("发运基地名称")
    private String desName;
    @ApiModelProperty("开票客户编码")
    private String billtoCustCode;
    @ApiModelProperty("开票客户名称")
    private String billtoCustName;
    @ApiModelProperty("返利账户编码")
    private String flAccCode;
    @ApiModelProperty("储值账号编码")
    private String czAccCode;
    private String custCode;
    private String custName;
    private String custCode2;
    @ApiModelProperty("订单渠道")
    private String channelType;
    private String channelTypeName;

    @ApiModelProperty("订单状态")
    private String docStatus;
    private String docStatusName;

    @ApiModelProperty("销售单编号")
    private String salSoNo;

    @ApiModelProperty("发货单编号")
    private String salDoNo;

    @ApiModelProperty("发货日期")
    private LocalDateTime docTime;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("对内商品名称")
    private String itemName;

    @ApiModelProperty("商品图片")
    private String imgFileCode;

    @ApiModelProperty("对外商品名称")
    private String outerItemName;

    @ApiModelProperty("规格")
    private String spec;

    @ApiModelProperty("单价")
    private BigDecimal price;

    @ApiModelProperty("数量")
    private BigDecimal num;

    @ApiModelProperty("金额")
    private BigDecimal amt;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("签收时间")
    private LocalDateTime recvConfirmTime;
}
