package com.elitesland.yst.lm.order.rpc.param.resp;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @Author: ryan.xu
 * @since 2023/3/28
 */

@Data
@ApiModel("未发货单查询返回明细实体")
public class LmUnShippedDRespDTO implements Serializable {
    private static final long serialVersionUID = -5698323972975414950L;

    @ApiModelProperty("销售单ID")
    private Long id;

    @ApiModelProperty("订单编号")
    private String docNo;

    @ApiModelProperty("订单类型")
    private String docType;
    private String docTypeName;

    @ApiModelProperty("订单状态")
    private String docStatus;
    private String docStatusName;

    @ApiModelProperty("订单日期")
    private LocalDateTime docTime;
    @ApiModelProperty("开票至客户编码")
    private String billtoCustCode;

    @ApiModelProperty("开票至客户名称")
    private String billtoCustName;
    @ApiModelProperty("商品编码")
    private String itemCode;

    private String itemAbbr;

    @ApiModelProperty("对内商品名称")
    private String itemName;

    @ApiModelProperty("对外商品名称")
    private String outerItemName;

    @ApiModelProperty("商品图片")
    private String imgFileCode;

    @ApiModelProperty("规格")
    private String spec;

    @ApiModelProperty("单价")
    private BigDecimal price;

    @ApiModelProperty("数量")
    private BigDecimal num;

    @ApiModelProperty("金额")
    private BigDecimal amt;

    @ApiModelProperty("备注")
    private String remark;
}
