package com.elitesland.yst.lm.order.rpc.param.resp;

import com.elitescloud.cloudt.common.base.PagingVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @Author: ryan.xu
 * @since 2023/3/25
 */
@Data
@ApiModel("发货单查询返回实体")
public class LmSalDoRespDTO implements Serializable {
    private static final long serialVersionUID = -5698023872975414950L;

    @ApiModelProperty("发货金额")
    private BigDecimal totalAmt;
    @ApiModelProperty("附件包数量汇总")
    private BigDecimal acceQty;

    @ApiModelProperty("整车/辆")
    private BigDecimal num;

    @ApiModelProperty("随车充电器/只")
    private BigDecimal chargerNum;

    @ApiModelProperty("随车电池/组")
    private BigDecimal batteryNum;

    private PagingVO<LmSalDoDRespDTO> salDoPageVO;

}
