package com.elitesland.yst.lm.order.rpc.param.resp;

import com.elitescloud.cloudt.common.base.PagingVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @Author: ryan.xu
 * @since 2023/3/28
 */
@Data
@ApiModel("未发货单查询返回实体")
public class LmUnShippedRespDTO implements Serializable {

    private static final long serialVersionUID = -5698023972975414950L;

    @ApiModelProperty("未发货金额")
    private BigDecimal totalAmt;

    @ApiModelProperty("整车/辆")
    private BigDecimal carQty;
    @ApiModelProperty("随车充电器/只")
    private BigDecimal chargerQty;
    @ApiModelProperty("随车电池/组")
    private BigDecimal batteryQty;

    @ApiModelProperty("未发货订单明细")
    private PagingVO<LmUnShippedDRespDTO> salDoPageVO;
}
