package com.elitesland.tw.tw5.api.bpm.common.service.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.tw.tw5.api.bpm.common.payload.BpmPayload;
import com.elitesland.tw.tw5.api.bpm.common.payload.BpmUserRefOaPayload;
import com.elitesland.tw.tw5.api.bpm.common.vo.BpmVO;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(value = "bpm", path = "rpc/bpm/common")
public interface BpmService {

    @PostMapping("submit")
    @ApiOperation("提交流程")
    ApiResult<BpmVO> submit(@RequestBody BpmPayload payload);

    @GetMapping("getOaUserIdByOaNo")
    @ApiOperation("根据OA工号获取OA用户id")
    ApiResult<String> getOaUserIdByOaNo(@RequestParam String workCode);

    @PostMapping("syncUserRefByOa")
    @ApiOperation("同步用户关系")
    ApiResult syncUserRefByOa(@RequestParam String sourceCode,@RequestParam String targetCode,@RequestBody List<BpmUserRefOaPayload> refList);

}
