package com.elitesland.tw.tw5.api.bpm.common.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * bpm组织dto
 *
 * @author duwh
 * @date 2024/04/10
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class BpmOrgDTO implements Serializable {

    private static final long serialVersionUID = 1L;
    /**
     * 用户ID
     */
    @ApiModelProperty("记录唯一ID")
    private Long id;

    /**
     * 租户ID
     */
    @ApiModelProperty(value = "租户ID")
    private Long tenantId;

    /**
     * 组织id
     */
    private Long orgId;

    /**
     * 组织名称
     */
    private String orgName;

    /**
     * 父id
     */
    private Long parentId;

    /**
     * 父名称
     */
    private String parentName;


}
