package com.elitesland.tw.tw5.api.bpm.weavere9.payload;

import lombok.Data;

import java.io.Serializable;


@Data
/**
 * 工作流字段信息
 */
public class WorkflowRequestTableField implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = -2865596549306206630L;

	/**
	 * 字段ID
	 */
	private String fieldId;
	
	/**
	 * 字段名称
	 */
	private String fieldName;
	
	/**
	 * 字段值
	 * 1、字符串
	 * 2、对象
	 * 3、数据对象
	 *
	 * [
	 *   {
	 *     "fieldName": "dhwb",
	 *     "fieldValue": {
	 *       "value": "1212",
	 *       "name": "aaaa.html"
	 *     }
	 *   },
	 *   {
	 *     "fieldName": "drlzy",
	 *     "fieldValue": "2978"
	 *   },
	 *   {
	 *     "fieldName": "drlzy1",
	 *     "fieldValue": "2978,2979"
	 *   },
	 *   {
	 *     "fieldName": "fjsc",
	 *     "fieldValue": [
	 *       {
	 *         "filePath": "https://timgsa.baidu.com/timg?image&quality=80&size=b9999_10000&sec=1577426926378&di=0084fc19f5cb90fc2286aab5ca8c343e&imgtype=0&src=http%3A%2F%2Fpic.51yuansu.com%2Fpic2%2Fcover%2F00%2F41%2F80%2F581369c715701_610.jpg",
	 *         "fileName": "timg.jpg"
	 *       },
	 *       {
	 *         "filePath": "http://192.168.7.216:8080/weaver/weaver.file.FileDownload?download=1&fileid=3819049&authStr=dmlld0NoYWluPTIyNTkzOTA1fG1haW5pZD0yMjU5MzkwNXw=&authSignatureStr=81b08f6e0b8ee06dcc1b43fda8204bdf&requestid=22593905&f_weaver_belongto_userid=4548&f_weaver_belongto_usertype=0",
	 *         "fileName": "自由节点视图mysql.txt"
	 *       }
	 *     ]
	 *   }
	 * ]
	 */
	private Object fieldValue;
	
	/**
	 * 界面字段表现形式
	 */
	private String fieldHtmlType;
	
	/**
	 * 界面字段类型
	 */
	private String fieldType;
	
	/**
	 * 数据库字段类型
	 */
	private String fieldDBType;
	
	/**
	 * 表单中提交的字段名
	 */
	private String fieldFormName;
	
	/**
	 * 显示顺序
	 */
	private int fieldOrder;
	
	/**
	 * 是否显示
	 */
	private boolean isView;
	
	/**
	 * 是否可编辑
	 */
	private boolean isEdit;
	
	/**
	 * 是否必填
	 */
	private boolean isMand;
	
	/**
	 * 显示字段名称
	 */
	private String fieldShowName;
	
	/**
	 * 浏览框字段URL
	 */
	private String browserurl;
	
	/**
	 * 下拉框字段信息
	 */
	private String[] selectnames;
	private String[] selectvalues;
	
	/**
	 * 显示字段值
	 */
	private String fieldShowValue;
	
	/**
	 * 字段html显示
	 */
	private String filedHtmlShow;



}
