package com.elitesland.tw.tw5.api.bpm.common.util;

import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.tw.tw5.api.bpm.common.constants.BpmDataKeyCommonEnum;
import com.elitesland.tw.tw5.api.bpm.common.dto.BpmOrgDTO;
import com.elitesland.tw.tw5.api.bpm.common.dto.BpmUserDTO;
import com.elitesland.tw.tw5.api.bpm.common.dto.SysUserCommonDTO;

import java.util.Map;

/**
 * 公用数据实用程序
 *
 * @author duwh
 * @date 2024/04/10
 */
public class BpmCommonDataUtil {


    /**
     * 设置用户和组织信息
     *
     * @param data     数据
     * @param userId   用户id
     * @param userName 用户名
     * @param orgId    组织id
     * @param orgName  组织名称
     * @return {@link Map}<{@link String}, {@link Object}>
     */
    public static Map<String, Object> setUserAndOrgInfo(Map<String, Object> data,
                                                        Long userId,
                                                        String userName,
                                                        Long orgId,
                                                        String orgName) {

        return setUserAndOrgInfo(data,
                userId,
                userName,
                null,
                null,
                null,
                null,
                0L,
                null,
                null,
                null,
                orgId,
                orgName,
                null,
                null
        );
    }

    /**
     * 设置用户和组织信息
     *
     * @param data             数据
     * @param userId           用户id
     * @param userName         姓名
     * @param userLogin        用户登录账号
     * @param email            电子邮件
     * @param mobile           手机号
     * @param userNo           用户编号
     * @param userParentId     用户父id
     * @param userParenName    用户paren名称
     * @param sysUserDTO       系统用户dto
     * @param sysUserCommonDTO sys用户通用dto
     * @param orgId            组织id
     * @param orgName          组织名称
     * @param orgParentId      组织父id
     * @param orgParentName    组织父名称
     * @return {@link Map}<{@link String}, {@link Object}>
     */
    public static Map<String, Object> setUserAndOrgInfo(Map<String, Object> data,
                                                        Long userId,
                                                        String userName,
                                                        String userLogin,
                                                        String email,
                                                        String mobile,
                                                        String userNo,
                                                        Long userParentId,
                                                        String userParenName,
                                                        SysUserDTO sysUserDTO,
                                                        SysUserCommonDTO sysUserCommonDTO,
                                                        Long orgId,
                                                        String orgName,
                                                        Long orgParentId,
                                                        String orgParentName

    ) {
        BpmUserDTO bpmUserDTO =
                BpmUserDTO.builder()
                        .id(userId)
                        .userId(userId)
                        // 资源姓名
                        .userName(userName)
                        // 用户登录账号
                        .userLogin(userLogin)
                        .email(email)
                        .mobile(mobile)
                        .userNo(userNo)
                        // 用户信息
                        .sysUser(sysUserDTO)
                        .sysUserCommon(sysUserCommonDTO)
                        // 组织信息
                        .orgId(orgId)
                        .orgName(orgName)
                        // 上级信息
                        .parentId(userParentId)
                        .parentName(userParenName)
                        .build();
        // 用户信息 放入业务数据集合中
        data.put(BpmDataKeyCommonEnum.USER.getCode(), bpmUserDTO);

        // 当前用户所属组织信息
        BpmOrgDTO bpmOrgDTO = BpmOrgDTO.builder()
                .id(orgId)
                .orgId(orgId)
                .orgName(orgName)
                // 按需赋值 组织的上级组织
                .parentId(orgParentId)
                .parentName(orgParentName)
                .build();
        data.put(BpmDataKeyCommonEnum.ORG.getCode(), bpmOrgDTO);
        return data;
    }

}
