package com.elitesland.tw.tw5.api.prd.crm.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;
import java.util.List;

/**
 * @author zoey
 * @Description:公海、潜在客户表
 * @date 2022/5/17 - 14:13
 */
@Data
public class CrmPotentialCustomerQuery extends TwQueryParam {

    /**
     * 潜在客户ids
     */
    private Long []  potentialCustomerIds;

    /**
     * 潜在客户ids  用于列表按跟进时间筛选
     */
    private List<Long> potentialCustomerIdsForFollow;

    /**
     * 公海id
     */
    private Long openseaId;
    /**
     * 公海id集合  英文逗号隔开
     */
    private String openseaIds;

    /**
     * 标签id
     */
    private String tagIds;

    /**
     * 市场活动项目id
     */
    private Long marketId;

    /**
     * 客户名称
     **/
    private String customerName;

    private String customerNameEqual;

    /**
     * 客户编号
     **/
    private String customerNo;

    /**
     * 客户状态
     **/
    private String customerStatus;

    /**
     * 客户级别
     **/
    private String customerGrade;

    /**
     * 客户行业
     */
    private String customerIndustry;

    /**
     * 联系人姓名
     **/
    private String customerContacts;

    /**
     * 客户电话
     **/
    private String customerPhone;

    /**
     * 客户邮箱
     **/
    private String customerEmail;

    /**
     * 客户地址-省
     **/
    private String customerLocationProvince;

    /**
     * 客户地址-市
     **/
    private String customerLocationCity;

    /**
     * 客户地址-区
     **/
    private String customerLocationDistrict;

    /**
     * 客户地址-省
     **/
    private String customerLocationProvinceName;

    /**
     * 客户地址-市
     **/
    private String customerLocationCityName;

    /**
     * 客户地址-区
     **/
    private String customerLocationDistrictName;

    /**
     * 客户地址-详细地址
     **/
    private String customerLocationDetail;

    /**
     * 模板：model 数据：data
     */
    private String downloadType;

    /**
     * 需求产品
     */
    private String demandProduct;

    /**
     * 跟进时间  创建时间区间开始
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime followCreateTimeStart;

    /**
     * 跟进时间  创建时间区间结束
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime followCreateTimeEnd;


    /**
     * 客户区域
     */
    private String custRegion;

    /**
     * 市场渠道
     */
    private String marketChannel;

    /**
     * 联系人部门
     */
    private String contactsDepartment;

    /**
     * 联系人岗位
     */
    private String contactsPosition;


    private String area;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createTimeStart;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createTimeEnd;


    /**
     * 是否查看第一条跟进
     */
    private Boolean queryFirstFollow;

    /**
     * 业务伙伴主键 business_partner.id
     */
    private Long partnerId;

}
