package com.elitesland.tw.tw5.api.prd.org.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgEmployeePayload;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgEmployeeRefPayload;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgTenantEmployeePayload;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgEmployeeQuery;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface PrdOrgEmployeeService {

    /**
     * 新增
     *
     * @param payload 单据数据
     */
    PrdOrgEmployeeVO insert(PrdOrgEmployeePayload payload);

    PrdOrgEmployeeVO insertByTenant(PrdOrgEmployeePayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     */
    Long update(PrdOrgEmployeePayload payload);

    /**
     * 修改用户信息 for  APP
     *
     * @param payload 有效载荷
     * @return {@link Long}
     */
    Long updateForApp(PrdOrgEmployeePayload payload);

    /**
     * 修改组织关系
     *
     * @param payloads 单据数据
     */
    Long updateEmployeeRef(List<PrdOrgEmployeeRefPayload> payloads);

    /**
     * 查询员工列表
     *
     * @return
     */
    List<PrdOrgEmployeeVO> queryList(PrdOrgEmployeeQuery query);

    /**
     * 查询员工详情
     *
     * @return
     */
    PrdOrgEmployeeVO queryByKey(Long key);


    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    PagingVO<PrdOrgEmployeeVO> paging(PrdOrgEmployeeQuery query);

    /**
     * 员工逻辑删除
     *
     * @param keys 主键
     * @return result
     */
    boolean deleteSoft(List<Long> keys);

    /**
     * 重置密码
     *
     * @param employeeId 被操作人id
     */
    boolean resetEmployeePawword(Long employeeId);

    /**
     * 批量导出excel
     *
     * @param response 请求响应
     * @param query    查询条件
     */
    void downloadPlus(HttpServletResponse response, PrdOrgEmployeeQuery query);

    /**
     * 批量立项导入excel
     *
     * @param file 请求响应
     */
    boolean importEmployees(MultipartFile file);

    /**
     * 移除员工组织
     *
     * @param employeeId 员工id
     * @param orgIds     组织ids
     * @return result
     */
    boolean deleteOrgRefSoft(Long employeeId, List<Long> orgIds);

    /**
     * 更新企业微信id
     *
     * @param userIds
     * @return result
     */
    boolean updateWecomId(List<Long> userIds);


    /**
     * 获取4.0和5.0用户对应关系Map
     *
     * @return
     */
    Map<Long, Long> getV4AndV5UserIds();

    /**
     * 获取所有上级userIds
     *
     * @param userId
     * @return
     */
    Set<Long> queryParentIdsByUserId(Long userId);

    /**
     * 查询下级 （直属下级）
     *
     * @param userId 用户id
     * @return {@link Set}<{@link Long}>
     */
    Set<Long> queryOneSubordinatesIdsByUserId(Long userId);

    /**
     * 查询下级id集合（下级 下级的下级  下级的下级的下级....）
     *
     * @param userId 用户id
     * @return {@link Set}<{@link Long}>
     */
    Set<Long> querySubordinatesIdsByUserId(Long userId);

    /**
     * 查找上级 （直属上级）
     *
     * @param userId 用户id
     * @return {@link Set}<{@link Long}>
     */
    Set<Long> queryOneParentIdsByUserId(Long userId);
//    /**
//     * 全局更新企业微信id
//     *
//     * @return result
//     */
//    boolean updateAllWecomId();

    /**
     * 通过租户新增
     *
     * @param payload 单据数据
     */
    PrdOrgEmployeeVO saveTenantUser(PrdOrgTenantEmployeePayload payload);

    PrdOrgEmployeeRefVO queryEmployeeRef(Long userId);

    /**
     * 查找上级 （直属上级）
     *
     * @param userIds 用户id
     * @return {@link Set}<{@link Long}>
     */
    Set<Long> queryParentIdByIds(List<Long> userIds);

}
