package com.elitesland.tw.tw5.api.prd.work.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.work.payload.PrdWorkAssignmentPayload;
import com.elitesland.tw.tw5.api.prd.work.query.PrdWorkAssignmentQuery;
import com.elitesland.tw.tw5.api.prd.work.vo.PrdWorkAssignmentVO;

import java.util.List;

/**
 * @author Lemon
 */
public interface PrdWorkAssignmentService {

    /**
     * 新增
     *
     * @param payload 单条数据
     */
    PrdWorkAssignmentVO insert(PrdWorkAssignmentPayload payload);

    /**
     * 修改
     *
     * @param payload 根据主键动态修改单条数据
     */
    Long updateByKeyDynamic(PrdWorkAssignmentPayload payload);

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    PagingVO<PrdWorkAssignmentVO> paging(PrdWorkAssignmentQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return vo对象
     */
    PrdWorkAssignmentVO queryByKey(Long key);

    /**
     * 暂挂
     * @param keys
     * @return
     */
    Boolean pending(List<Long> keys);

    /**
     * 暂挂
     * @param keys
     * @return
     */
    Boolean start(List<Long> keys);

    /**
     * 完成
     * @param keys
     * @return
     */
    Boolean finish(List<Long> keys);

    /**
     * 关闭
     * @param keys
     * @return
     */
    Boolean close(List<Long> keys);

    /**
     * 关闭
     * @param
     * @return
     */
    List<PrdWorkAssignmentVO> queryList(PrdWorkAssignmentQuery query);

    /**
     * 逻辑删除
     *
     * @param keys 主键
     * @return result
     */
    boolean deleteSoft(List<Long> keys);
}
