package com.elitesland.tw.tw5.api.demo.student.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serial;
import java.io.Serializable;
import java.time.LocalDate;

/**
 * 学生 query对象
 * @author zhangyongqiang
 */
@Data
public class DemoStudentQuery extends TwQueryParam implements Serializable {
    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 学号
     */
    @ApiModelProperty("学号")
    private String studentNo;

    /**
     * 姓名
     */
    @ApiModelProperty("姓名")
    private String studentName;

    /**
     * 年龄
     */
    @ApiModelProperty("年龄")
    private Integer age;

    /**
     * 性别
     */
    @ApiModelProperty("性别")
    private String sex;

    /**
     * 生日
     */
    @ApiModelProperty("生日")
    private LocalDate birthday;

    /**
     * 班级Id
     */
    @ApiModelProperty("班级Id")
    private Long  classId;

    /**
     * 班级名称
     */
    @ApiModelProperty("班级名称")
    private String  className;
}
