package com.elitesland.tw.tw5.api.prd.crm.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmCustomerOperationPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmCustomerOperationBusinessQuery;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmCustomerOperationQuery;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerDataVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerOperationSimpleVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerOperationVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmFollowVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemLogVO;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * 客户经营
 *
 * @author duwh
 * @date 2022/11/15
 */
public interface CrmCustomerOperationService {

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link CrmCustomerOperationVO}
     */
    CrmCustomerOperationVO insert(CrmCustomerOperationPayload payload);

    /**
     * 检查 名称 唯一性
     *
     * @param custName 名称
     * @return int
     */
    int checkCustNameUnique(String custName);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link CrmCustomerOperationVO}
     */
    CrmCustomerOperationVO update(CrmCustomerOperationPayload payload);

    /**
     * 修改客户经营状态
     * @param key
     * @param custOperStatus
     * @return
     */
    boolean updateCustOperStatus(Long key, String custOperStatus);

    /**
     * 关联客户
     *
     * @param payload
     */
    void relationCustomer(CrmCustomerOperationPayload payload);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return vo对象
     */
    CrmCustomerOperationVO queryByKey(Long key);

    /**
     * 查询日志列表
     *
     * @param id id
     * @return {@link List}<{@link PrdSystemLogVO}>
     */
    List<PrdSystemLogVO> queryLogList(Long id);

    /**
     * 查询列表
     *
     * @param query 查询
     * @return {@link List}<{@link CrmCustomerOperationVO}>
     */
    List<CrmCustomerOperationVO> queryList(CrmCustomerOperationQuery query);

    /**
     * 数据权限 查询列表
     *
     * @param query 查询
     * @return {@link List}<{@link CrmCustomerOperationVO}>
     */
    List<CrmCustomerOperationVO> queryListDataFilter(CrmCustomerOperationQuery query);

    /**
     * 数据权限 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    PagingVO<CrmCustomerOperationVO> pagingDataFilter(CrmCustomerOperationQuery query);

    /**
     * 分页
     *
     * @param query 查询
     * @return {@link PagingVO}<{@link CrmCustomerOperationVO}>
     */
    PagingVO<CrmCustomerOperationVO> paging(CrmCustomerOperationQuery query);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 选择列表
     *
     * @param query 查询
     * @return {@link List}<{@link CrmCustomerOperationSimpleVO}>
     */
    List<CrmCustomerOperationSimpleVO> selectList(CrmCustomerOperationQuery query);

    /**
     * 查询客户下面的经营往来
     *
     * @param operId
     * @return
     */
    List<CrmFollowVO> queryOperateFollowList(Long operId);

    /**
     * 分页查询业务往来
     *
     * @param query 查询参数
     * @return 分页结果
     */
    Object queryBusinessFollowPaging(CrmCustomerOperationBusinessQuery query);

    /**
     * 查询客户数据
     *
     * @param operId
     * @return
     */
    CrmCustomerDataVO queryCustomerByOperId(Long operId);

    /**
     * 查询客户概览
     *
     * @param operId
     * @return
     */
    Object queryCustomerView(Long operId);

    /**
     * excel导入
     *
     * @param file     文件
     * @param force    力
     * @param response 响应
     * @return {@link Map}<{@link String}, {@link Object}>
     * @throws IOException ioexception
     */
    Map<String, Object> excelImport(MultipartFile file, Boolean force, HttpServletResponse response) throws IOException;

    /**
     * 查询缺失启信宝信息的客户经营
     * @return
     */
    List<CrmCustomerOperationVO> findOperationEnterpriseInfoAbsent();

    /**
     * 为一个客户经营补充启信宝信息
     * @return 成功 true, 失败 false
     */
    boolean fillQxbInfo(String custName, long operId);

//    /**
//     * 分页查询客户合同
//     *
//     * @param query
//     * @param customerId
//     * @return
//     */
//    public Map<String, Object> queryContractFollow(TwQueryParam query, Long customerId);
//
//    /**
//     * 分页查询客户线索
//     *
//     * @param query
//     * @param customerId
//     * @return
//     */
//    public PagingVO<CrmLeadsListVO> queryLeadsFollow(TwQueryParam query, Long customerId);
//
//    /**
//     * 分页查询客户商机
//     *
//     * @param query
//     * @param customerId
//     * @return
//     */
//    public PagingVO<CrmOpportunityVO> queryOppoFollow(TwQueryParam query, Long customerId);
}
