package com.elitesland.tw.tw5.api.prd.ab.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import lombok.Data;

/**
 * @Author carl.wang
 * @Description 客户表
 * @Date
 **/

@Data

public class PrdAbOrCompanyPayload extends TwCommonPayload {

    /**
     * tw4.0地址薄ID
     */
    private Long bookIdV4;
    /**
     * 地址簿编号
     */
    private String bookNo;
    /**
     * 地址簿类型(公司，个人)
     */
    private String bookType;

    /**
     * 关系类型(内部公司，客户，供应商，合作伙伴)
     * [udc] prd:ab:relate:intercompany
     */
    private String relateType;

    /**
     * 公司名称
     */
    private String companyName;

    /**
     * 客户行业
     */
    private String companyIndustry;

    /**
     * 电话
     */
    private String companyPhone;

    /**
     * 邮箱
     */
    private String companyEmail;

    /**
     * 传真
     */
    private String companyFax;
    /**
     * 省
     */
    private String province;
    /**
     * 省
     */
    private String provinceName;
    /**
     * 市
     */
    private String city;
    /**
     * 市
     */
    private String cityName;
    /**
     * 区
     */
    private String district;
    /**
     * 区
     */
    private String districtName;
    /**
     * 详细地址
     */
    private String companyAddress;
    /**
     * 网址
     */
    private String companyWebsite;
    /**
     * 规模
     */
    private String companyScale;
    /**
     * 税号
     */
    private String taxNo;
    /**
     * 交易货币
     */
    private String currency;
    /**
     * 语言
     */
    private String language;
    /**
     * 公司性质
     */
    private String companyNature;

    /**
     * 经纬度
     */
    private String longitudeLatitude;
}
