package com.elitesland.tw.tw5.api.common.funConfig.vo;

import cn.hutool.json.JSONUtil;
import com.elitescloud.cloudt.common.base.BaseViewModel;
import com.elitesland.tw.tw5.api.common.funConfig.dto.BusinessPageJsonDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.util.StringUtils;

import java.io.Serializable;


/**
  * 页面配置
  *
  * @author duwh
  * @date 2023-06-20
  */
@Getter
@Setter
public class BusinessPageVO extends BaseViewModel implements Serializable {
    /** 名称 */
    @ApiModelProperty("名称")
    private String name;
    /** 编码 */
    @ApiModelProperty("编码")
    private String code;
    /** 类型 PC APP H5 FLUTTER SPECIAL(特殊，虚拟) */
    @ApiModelProperty("类型 PC APP H5 FLUTTER SPECIAL(特殊，虚拟)")
    private String type;
    /** 功能主键 prd_system_function.id */
    @ApiModelProperty("功能主键 prd_system_function.id")
    private Long functionId;
    /** 页面配置json内容 */
    @ApiModelProperty("页面配置json内容")
    private String jsonContent;

    /** 页面配置json内容 */
    @ApiModelProperty("页面配置json内容")
    private BusinessPageJsonDTO jsonDto;

    public BusinessPageJsonDTO getJsonDto() {
        if (StringUtils.hasText(jsonContent)) {
            BusinessPageJsonDTO businessPageJsonDTO = JSONUtil.toBean(jsonContent, BusinessPageJsonDTO.class);
            return businessPageJsonDTO;
        }
        return jsonDto;
    }

    /** 是否启用 true/1 启用 false/0 不启用 */
    @ApiModelProperty("是否启用 true/1 启用 false/0 不启用")
    private Boolean enabled;
    /** 排序号 */
    @ApiModelProperty("排序号")
    private Integer sortNo;
    /** 拓展字段1 */
    @ApiModelProperty("拓展字段1")
    private String ext1;
    /** 拓展字段2 */
    @ApiModelProperty("拓展字段2")
    private String ext2;
    /** 拓展字段3 */
    @ApiModelProperty("拓展字段3")
    private String ext3;
    /** 拓展字段4 */
    @ApiModelProperty("拓展字段4")
    private String ext4;
    /** 拓展字段5 */
    @ApiModelProperty("拓展字段5")
    private String ext5;
}
