package com.elitesland.tw.tw5.api.prd.crm.vo;

import com.elitescloud.cloudt.common.base.BaseViewModel;
import com.elitesland.tw.tw5.api.prd.prj.vo.PrjProjectMemberVO;
import com.elitesland.tw.tw5.api.udc.UdcName;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;

/**
 * @Author carl.wang
 * @Description 商机表
 * @Date
 **/
@Data
public class CrmOpportunityVO extends BaseViewModel {
    /**
     * 项目id
     */
    private Long projectId;
    /**
     * 项目名称（名称）
     */
    private String projectName;

    /**
     * 商机文件夹 对应在易稻壳itemId
     */
    private String itemId;
    /**
     * 创建人（报备人）
     */
    private String createUserName;

    /**
     * 活动id
     */
    private Long actId;

    /**
     * 活动名称
     */
    private String actName;

    /**
     * 项目编号（活动编号）
     */
    private String projectNo;

    /**
     * 签单负责人id
     */
    private Long manageUserId;
    /**
     * 签单负责人
     */
    private String manageUserName;
    /**
     * 签单buid
     */
    private Long orgId;
    /**
     * 签单bu名称
     */
    private String orgName;
    /**
     * 公司id
     */
    private Long companyId;
    /**
     * 附件地址codes（“，”分割字符串）
     */
    private String fileCodes;

    /**
     * 项目状态
     */
    private String projectStatus;
    /**
     * 项目状态名称
     */
    private String projectStatusName;

    /**
     * 关闭原因
     */
    private String closeReason;
    /**
     * 关闭原因
     */
    private String closeReasonName;
    /**
     * 丢单原因
     */
    private String loseReason;
    /**
     * 丢单原因
     */
    private String loseReasonName;
    /**
     * 关闭备注
     */
    private String clsoeRemark;

    /**
     * 线索id
     */
    private Long leadsId;
    /**
     * 线索名称
     */
    private String leadsName;
    /**
     * 销售产品
     */
    private String saleProduct;
    /**
     * 客户区域
     */
    private String custRegion;
    /**
     * 客户区域名称
     */
    private String custRegionName;
    /**
     * 是否老客户 0:Y,1:N
     */
    private Integer isOldCust;
    /**
     * 客户id 老客户才会选择
     */
    private Long custBookId;
    /**
     * 客户名称
     */
    private String custBookName;
    /**
     * 客户项目
     */
    private String custProject;
    /**
     * 客户联系人
     */
    private String contactName;
    /**
     * 客户联系电话
     */
    private String contactPhone;
    /**
     * 客户联系人部门
     */
    private String contactDept;
    /**
     * 客户联系人岗位
     */
    private String contactPosition;
    /**
     * 企业主页
     */
    private String contactWebsite;
    /**
     * 客户性质
     */
    private String custProp;
    /**
     * 客户性质名称
     */
    private String custPropName;
    /**
     * 客户行业
     */
    private String custIdst;
    /**
     * 客户行业名稱
     */
    private String custIdstName;
    /**
     * 预计成单日期
     */
    private LocalDate forecastWinDate;
    /**
     * 预计签单金额
     */
    private BigDecimal forecastAmount;
    /**
     * 成单概率
     */
    private String probability;
    /**
     * 成单概率名称
     */
    private String probabilityName;
    /**
     * 币种
     */
    private String currCode;
    /**
     * 币种名称
     */
    private String currCodeName;
    /**
     * 销售阶段
     */
    private String salePhase;
    /**
     * 销售阶段
     */
    private String salePhaseName;
    /**
     * 交付地点
     */
    private String deliveryAddress;
    /**
     * 商机级别
     */
    private String oppoLevel;
    /**
     * 商机级别
     */
    private String oppoLevelName;
    /**
     * 是否需要合作伙伴 0:Y,1:N
     */
    private Integer isNeedPartner;
    /**
     * 关联合作伙伴Id
     */
    private Long coopBookId;
    /**
     * 关联合作伙伴名称
     */
    private String coopBookName;
    /**
     * 合作伙伴描述
     */
    private String partnerDesc;
    /**
     * 售前bu
     */
    private Long preSaleOrgId;
    /**
     * 售前bu
     */
    private String preSaleOrgName;
    /**
     * 售前负责人
     */
    private Long preSaleUserId;
    /**
     * 售前负责人
     */
    private String preSaleUserName;
    /**
     * 项目难度
     */
    private String projectDifficult;
    /**
     * 项目难度
     */
    private String projectDifficultName;
    /**
     * 项目重要度
     */
    private String projectImportance;
    /**
     * 项目重要度
     */
    private String projectImportanceName;
    /**
     * 交付BU_ID
     */
    private Long deliOrgId;
    /**
     * 交付bu
     */
    private String deliOrgName;
    /**
     * 交付负责人ID
     */
    private Long deliUserId;
    /**
     * 交付负责人
     */
    private String deliUserName;
    /**
     * 方案难度
     */
    private String solutionDifficulty;
    /**
     * 方案难度
     */
    private String solutionDifficultyName;
    /**
     * 方案重要度
     */
    private String solutionImportance;
    /**
     * 方案重要度
     */
    private String solutionImportanceName;
    /**
     * 合作(副)签单BU_ID
     */
    private Long coOrgId;
    /**
     * 合作(副)签单BU
     */
    private String coOrgName;
    /**
     * 合作(副)签单负责人ID
     */
    private Long coUserId;
    /**
     * 合作(副)签单负责人ID
     */
    private String coUserName;
    /**
     * 合作(副)交付BU_ID
     */
    private Long codeliOrgId;
    /**
     * 合作(副)交付BU
     */
    private String codeliOrgName;
    /**
     * 合作(副)交付负责人ID
     */
    private Long codeliUserId;
    /**
     * 合作(副)交付负责人
     */
    private String codeliUserName;
    /**
     * 来源类型
     */
    private String sourceType;
    /**
     * 内部来源BU_ID
     */
    private Long internalOrgId;
    /**
     * 内部来源BU
     */
    private String internalOrgName;
    /**
     * 内部来源人ID
     */
    private Long internalUserId;
    /**
     * 内部来源人ID
     */
    private String internalUserName;
    /**
     * 外部线索来源
     */
    private String externalIden;
    /**
     * 外部来源人
     */
    private String externalName;
    /**
     * 外部来源电话
     */
    private String externalPhone;
    /**
     * 利益承诺
     */
    private String profitDesc;
    /**
     * 团队成员
     */
    private List<PrjProjectMemberVO> memberVOS;

    /**
     * 关联正式客户id
     */
    private Long formalCustomerId;

    private String IsShow1;
    private String IsShow2;
    private String IsShow3;

    private String extString1;
    private String extString2;
    private String extString3;
    private String extString4;
    private String extString5;

    private Long oppoIdV4;

    private String order;

    private String forecastWinDateStr;
    private String isNeedPartnerStr;

    private String members;
    // 业务伙伴主键 business_partner.id
    private Long partnerId;

    private Long saleUserId;

    private String saleUserName;

    /**
     * 验证状态
     */
    private String checkStatus;
    @UdcName(udcName = "crm:oppo:check_status", codePropName = "checkStatus")
    private String checkStatusName;

}
