package com.elitesland.tw.tw5.api.prd.schedule.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDate;

/**
 * @author zoey
 * @Description:
 * @date 2022/4/19 - 14:36
 */
@Data
public class PrdScheduleRepeatPayload extends TwCommonPayload {

    @ApiModelProperty("重复类型")
    private Integer repeatType;

    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty("重复结束时刻")
    private LocalDate repeatUntil;

    @ApiModelProperty("是否自定义重复")
    private Integer isCustomRepeat;

    @ApiModelProperty("重复间隔")
    private Integer repeatInterval=1;

    @ApiModelProperty("每周周几重复")
    private String repeatDayOfWeek;

    @ApiModelProperty("每月哪几天重复")
    private String repeatDayOfMonth;

    @ApiModelProperty("排除日期String类型，逗号分隔")
    private String exdate;

    @ApiModelProperty("日程id")
    private Long secheduleId;
}
