package com.elitesland.tw.tw5.api.prd.system.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdCommentPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdCommentQuery;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdCommentVO;

import java.util.List;


/**
 * prd评论服务
 *
 * @author duwh
 * @date 2022/11/22
 */
public interface PrdCommentService {

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link PrdCommentVO}
     */
    PrdCommentVO insert(PrdCommentPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link PrdCommentVO}
     */
    PrdCommentVO update(PrdCommentPayload payload);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return vo对象
     */
    PrdCommentVO queryByKey(Long key);

    /**
     * 查询列表
     *
     * @param query 查询
     * @return {@link List}<{@link PrdCommentVO}>
     */
    List<PrdCommentVO> queryList(PrdCommentQuery query);

    /**
     * 统计个数
     *
     * @param query 查询
     * @return long
     */
    long count(PrdCommentQuery query);

    /**
     * 统计个数
     *
     * @param objTypeEnum obj枚举类型  see  PrdCommentObjTypeEnum
     * @param objId       obj id
     * @return long
     */
    long count(String objTypeEnum, Long objId);

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    PagingVO<PrdCommentVO> paging(PrdCommentQuery query);

    /**
     * 分页  带二级评论
     *
     * @param query 查询
     * @return {@link PagingVO}<{@link PrdCommentVO}>
     */
    PagingVO<PrdCommentVO> pagingPro(PrdCommentQuery query);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);


    /**
     * 查询列表支持
     *
     * @param query 查询
     * @return {@link List}<{@link PrdCommentVO}>
     */
    List<PrdCommentVO> queryListPro(PrdCommentQuery query);
}
