package com.elitesland.tw.tw5.api.tenant.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.tenant.payload.AuthTenantPayload;
import com.elitesland.tw.tw5.api.tenant.query.AuthTenantQuery;
import com.elitesland.tw.tw5.api.tenant.vo.AuthTenantVO;

import java.util.List;

/**
 * 租户授权
 *
 * @author duwh
 * @date 2023-04-02
 */
public interface AuthTenantService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link AuthTenantVO}>
     */
    PagingVO<AuthTenantVO> paging(AuthTenantQuery query);

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link AuthTenantVO}>
     */
    PagingVO<AuthTenantVO> queryPaging(AuthTenantQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link AuthTenantVO}>
     */
    List<AuthTenantVO> queryList(AuthTenantQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link AuthTenantVO}>
     */
    List<AuthTenantVO> queryListDynamic(AuthTenantQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link AuthTenantVO}
     */
    AuthTenantVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link AuthTenantVO}
     */
    AuthTenantVO insert(AuthTenantPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link AuthTenantVO}
     */
    AuthTenantVO update(AuthTenantPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

}
