package com.elitesland.tw.tw5.api.prd.crm.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author zoey
 * @Description:线索表
 * @date 2022/5/17 - 11:38
 */
@Data
public class CrmLeadsOffshoreQuery extends TwQueryParam {

    /**
     * 线索状态
     */
    private List<String> leadsStatusList;


    /**
     * 创建人或者销售
     */
    private Long saleOrCreateUserId;

    //=======================线索表查询字段========================

    /**
     * 标签查询条件
     */
    private String leadsTagIds;

    /**
     * 线索ids
     */
    private Long []  leadsIds;

    /**
     * 线索集合 为了按 跟进时间筛选
     */
    private List<Long> leadsIdsForFollow;

    /**
     * 线索ids  英文逗号隔开
     */
    private String  leadsIdsStr;


    /**
     * 近海id
     */
    private Long offshoreId;

    /**
     * 近海id集合  英文逗号隔开
     */
    private String offshoreIds;

    /**
     * 线索编号
     */
    private String leadsNo;

    /**
     * 年营业额
     */
    private String annualTurnover;

    /**
     * 城市
     */
    private String area;

    /**
     * 线索名称
     */
    private String leadsName;

    /**
     * 线索状态
     */
    private String leadsStatus;

    /**
     * 创建人不等于
     */
    private Long createUserIdNotEqual;

    /**
     * 线索阶段
     */
    private String leadsStage;

    /**
     * 线索阶段
     */
    private String leadsStageNotEqual;


    /**
     * 线索对应的offshore
     */
    private Boolean filterLeadsOffshore;

    /**
     * 线索阶段
     */
    private List<String> leadsStageNotIn;


    /**
     * 来源类型
     */
    private String sourceType;

    /**
     * 市场活动项目id
     */
    private Long marketId;

    /**
     * 市场渠道
     */
    private String marketChannel;
    /**
     * 渠道
     */
    private String channel;

    /**
     * 销售负责人id
     */
    private Long saleUserId;

    /**
     * 奖金分配类型
     */
    private String bonusDistributeType;

    /**
     * 奖金分配对象
     */
    private Long bonusDistributeTo;

    /**
     * 关闭原因
     */
    private String closeReason;

    /**
     * 需求产品
     */
    private String demandProduct;

    /**
     * 需求产品部门
     */
    private Long demandProductOrg;

    /**
     * 退回原因
     */
    private String backReason;

    /**
     * 收回原因
     */
    private String withdrawReason;

    /**
     * 转移原因
     */
    private String transferReason;

    /**
     * 分配日期
     */
    private LocalDate distributeDate;


    /**
     * 分配日期超过天数
     */
    private Integer expireDays;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    /**
     *创建时间(报备时间)*/
    private LocalDateTime createTime;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    /**
     *创建时间区间开始*/
    private LocalDateTime createTimeStart;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    /**
     *创建时间区间结束*/
    private LocalDateTime createTimeEnd;
    //客户表
    /**
     * 客户名称
     */
    private String customerName;
    private String customerNameEqual;

    /**
     * 联系人姓名
     **/
    private String customerContacts;

    /**
     * 客户电话
     **/
    private String contactsPhone;
    /**
     * 客户邮箱
     **/
    private String contactsEmail;
    /**
     * 客户行业
     */
    private String customerIndustry;

    /**
     * 客户行业
     */
    private String customerGrade;

    /**
     * 客户区域
     */
    private String custRegion;

    /**
     * 来源人
     */
    private Long sourceUserId;

    //=====================offshore查询字段==================
    /**
     * 线索id
     */
    private Long leadsId;


    /**
     * 过滤近海
     */
    private Boolean filterOffshore;


    /**
     * 近海名称
     */
    private String offshoreName;

    /**
     * 管理员
     */
    private Long offshoreAdminId;

    /**
     * 成员
     */
    private Long memberId;

    /**
     * 分配领取规则
     */
    private String distributeReceiveRule;


    /**
     * 是否可分配
     */
    private Integer canDistribute;

    /**
     * 是否可领取
     */
    private Integer canReceive;

    /**
     * 模板：model 数据：data
     */
    private String downloadType;


    /**
     * 未分配提醒时间
     */
    private Boolean notDistributeLeadsRemindTimeNotNull;

    //----- 跟进

    /**
     * 跟进时间  创建时间区间开始
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime followCreateTimeStart;

    /**
     * 跟进时间  创建时间区间结束
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime followCreateTimeEnd;


}
