package com.elitesland.tw.tw5.api.prd.shorturl.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.shorturl.payload.ShortUrlRequestLogPayload;
import com.elitesland.tw.tw5.api.prd.shorturl.query.ShortUrlRequestLogQuery;
import com.elitesland.tw.tw5.api.prd.shorturl.vo.ShortUrlRefVO;
import com.elitesland.tw.tw5.api.prd.shorturl.vo.ShortUrlRequestLogVO;
import org.springframework.scheduling.annotation.Async;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * 短链服务请求记录
 *
 * @author duwh
 * @date 2023-05-19
 */
public interface ShortUrlRequestLogService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link ShortUrlRequestLogVO}>
     */
    PagingVO<ShortUrlRequestLogVO> queryPaging(ShortUrlRequestLogQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link ShortUrlRequestLogVO}>
     */
    List<ShortUrlRequestLogVO> queryListDynamic(ShortUrlRequestLogQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link ShortUrlRequestLogVO}
     */
    ShortUrlRequestLogVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link ShortUrlRequestLogVO}
     */
    ShortUrlRequestLogVO insert(ShortUrlRequestLogPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link ShortUrlRequestLogVO}
     */
    ShortUrlRequestLogVO update(ShortUrlRequestLogPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    @Async
    void log(ShortUrlRefVO shortUrlRefVO, HttpServletRequest request);
}
