package com.elitesland.tw.tw5.api.prd.crm.payload;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.tw.tw5.api.prd.prj.payload.PrjProjectPayload;
import lombok.Data;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author zoey
 * @Description:线索表
 * @date 2022/5/17 - 11:38
 */
@Data
public class CrmLeadsPayload extends TwCommonPayload {

//    /**
//     * 近海（多对多）
//     */
//    private List<CrmOffshorePayload> offshores;

//    private List<CrmLeadsOffshorePayload> leadsOffshores;

    private List<Long> offshoreIds;
    private List<Long> deleteOffshoreIds;
    private String offshoreIdsStr;//仅导入时用
    private String offshoreIdsDesc;//仅导入时用

    private Long oldOffshoreId;

    @Comment("线索标签列表")
    private String leadsTagIds;

    /**
     * 0:个人新增；1：销售新增；其他：线索池新增
     */
    private Long  leadsType;


    /**
     * 从近海维度查询，近海唯一
     */
    private Long offshoreId;

    private Long newOffshoreId;

    /**
     * 线索编号
     */
    private String leadsNo;

    /**
     * 线索名称
     */
    private String leadsName;

    /**
     * 线索状态
     */
    private String leadsStatus;

    /**
     * 线索阶段
     */
    private String leadsStage;

    /**
     * 来源类型
     */
    private String sourceType;
    private String sourceTypeDesc;//仅导入时用


    /**
     * 市场活动
     */
    private PrjProjectPayload market;
    private String marketId;//仅导入时用
    private String marketIdDesc;//仅导入时用

    /**
     * 销售负责人
     */
    private Long saleUserId;
    private String saleUserName;//仅导入时用

    /**
     * 上一任负责人
     */
    private Long preSaleUserId;

    /**
     * 奖金分配对象
     */
    private Long bonusDistributeTo;

    /**
     * 来源人
     */
    private Long sourceUserId;
    private String sourceUserName;//仅导入时用

//    /**
//     * 市场活动项目id
//     */
//    private Long marketId;
    /**
     * 市场渠道
     */
    private String marketChannel;


    /**
     * 渠道
     */
    private String channel;

//    /**
//     * 销售负责人id
//     */
//    private Long saleUserId;

    /**
     * 奖金分配类型
     */
    private String bonusDistributeType;


    /**
     * 关闭原因
     */
    private String closeReason;

    /**
     * 需求产品
     */
    private String demandProduct;

    /**
     * 需求产品部门
     */
    private Long demandProductOrg;

    /**
     * 退回原因
     */
    private String backReason;

    /**
     * 收回原因
     */
    private String withdrawReason;

    /**
     * 转移原因
     */
    private String transferReason;

    /**
     * 分配日期
     */
    private LocalDate distributeDate;


    /**
     * 关闭原因
     */
    private CrmLeadsCustomerPayload customer;

//    /**
//     * 操作日志表
//     */
//    private List<PrdSystemLogPayload> leadsLogs;

    /**
     * 线索成员表
     */
    private List<CrmLeadsMembersPayload> leadsMembers;

//    /**
//     * 线索跟进表
//     */
//    private List<CrmFollowPayload> leadsFollows;


    /**
     * 潜在客户id
     */
    private Long potentialCustomerId;


    /**
     * 潜在客户转移原因
     */
    private String potentialCustomerTransferReason;

    /**
     * 未跟进提醒时间
     */
    private LocalDateTime notFollowLeadsRemindTime;

    /**
     * 关联正式客户id
     * 该字段弃用 改为用业务伙伴id business_partner.id 进行客户关联 2023/06/09版本
     */
    private Long formalCustomerId;

    /**
     * 预留字段1
     */
    private String extString1;

    /**
     * 预留字段2
     */
    private String extString2;

    /**
     * 预留字段3
     */
    private String extString3;

    /**
     * 预留字段4
     */
    private String extString4;

    /**
     * 预留字段5
     */
    private String extString5;


    /**
     * 导入警告
     */
    private String importWarn;

    /**
     * 导入错误
     */
    private String imoprtError;


    /**
     * 4.0相关字段，还要同步回4.0或者需要翻译
     */
    private Long createUserIdV4;//创建人

    private Long internalBuIdV4;//来源部门

    private Long saleUserIdV4;//销售人员

    private Long sourceUserIdV4;//来源人

    private Long bonusDistributeToV4;//奖金分配对象，人，部门

    private Long leadsIdV4;//线索id

    private String annualTurnover;

    /**
     * 城市
     */
    private String area;

    /**
     * 业务伙伴主键 business_partner.id
     */
    private Long partnerId;


}
