package com.elitesland.tw.tw5.api.prd.schedule.vo;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseViewModel;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author zoey
 * @Description:
 * @date 2022/4/19 - 14:36
 */
@Data
public class PrdScheduleVO extends BaseViewModel {

    @ApiModelProperty("日程标题")
    private String title;

    @ApiModelProperty("日程描述")
    private String description;

    @ApiModelProperty("日程地址")
    private String location;

    @ApiModelProperty("全天")
    private Integer allDay;

    @ApiModelProperty("开始时间")
    private LocalDateTime startTime;

    @ApiModelProperty("结束时间")
    private LocalDateTime endTime;

    @ApiModelProperty("日历id")
    @JsonSerialize(
            using = ToStringSerializer.class
    )
    private Long calId;

    @ApiModelProperty("是否允许非参与人主动加入日程")
    private Integer allowActiveJoin;

    @ApiModelProperty("是否重复")
    private Integer isRepeat;

    @ApiModelProperty("是否提醒")
    private Integer isRemind;

    @ApiModelProperty("提前发送提醒时间")
    private Integer remindBeforeEventSecs;

    @ApiModelProperty("参与成员")
    private List<PrdScheduleAttendeesVO> attendeesVOS;

    @ApiModelProperty("重复信息")
    private PrdScheduleRepeatVO repeatVO;

    //以下是日程重复的属性
    @ApiModelProperty("重复类型")
    private Integer repeatType;

    @ApiModelProperty("重复结束时刻")
    private LocalDate repeatUntil;

    @ApiModelProperty("是否自定义重复")
    private Integer isCustomRepeat;

    @ApiModelProperty("重复间隔")
    private Integer repeatInterval;

    @ApiModelProperty("每周周几重复")
    private String repeatDayOfWeek;

    @ApiModelProperty("每月哪几天重复")
    private String repeatDayOfMonth;

    @ApiModelProperty("每月哪几天重复,将字母翻译成数字")
    private String repeatDayOfMonthNumber;

    @ApiModelProperty("排除日期String类型，逗号分隔")
    private String exdate;

    @ApiModelProperty("日程id")
    @JsonSerialize(
            using = ToStringSerializer.class
    )
    private Long secheduleId;

    @ApiModelProperty("创建人姓名")
    private String employeeName;

    @ApiModelProperty("日历颜色")
    private String color;

    @ApiModelProperty("日历标题")
    private String calTitle;


    @Comment("企业微信主键")
    @JsonSerialize(
            using = ToStringSerializer.class
    )
    private String qyWxScheduleId;
}
