package com.elitesland.tw.tw5.api.prd.system.service;

import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemMenuPayload;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemMenuVO;

import java.util.List;

/**
 * service
 *
 * @author wangding
 */
public interface PrdSystemMenuService {

    /**
     * 新增
     *
     * @param payload 单据数据
     */
    PrdSystemMenuVO insert(PrdSystemMenuPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     */
    Long update(PrdSystemMenuPayload payload);

    /**
     * 更改状态
     *
     * @param id 主键 status状态
     */
    Long updateStatus(Long id, Integer status);

    /**
     * 物理删除
     *
     * @param key 主键
     * @return result
     */
    boolean delete(Long key);

    /**
     * 逻辑删除
     *
     * @param key 主键
     * @return result
     */
    boolean deleteSoft(Long key);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return vo对象
     */
    PrdSystemMenuVO queryByKey(Long key);

    /**
     * 查询所有
     *
     * @return 分页结果
     */
    List<PrdSystemMenuVO> queryList();

    /**
     * 查询所有k可用菜单
     *
     * @return 分页结果
     */
    List<PrdSystemMenuVO> usableList();

    /**
     * 通过KEY查询直属子集
     *
     * @param key 下拉选择key
     * @return
     */
    List<PrdSystemMenuVO> selectByCondition(String key);
}
