package com.elitesland.tw.tw5.api.prd.crm.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.tw.tw5.api.prd.prj.payload.PrjProjectPayload;
import lombok.Data;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author zoey
 * @Description:线索表
 * @date 2022/5/17 - 11:38
 */
@Data
public class CrmLeadsDetailPayload extends TwCommonPayload {

//    /**
//     * 近海（多对多）
//     */
//    private List<CrmOffshorePayload> offshores;

//    private List<CrmLeadsOffshorePayload> leadsOffshores;

    private List<Long> offshoreIds;
    private List<Long> deleteOffshoreIds;

    /**
     * 0:个人新增；1：销售新增；其他：线索池新增
     */
    private Long leadsType;


    /**
     * 从近海维度查询，近海唯一
     */
    private Long offshoreId;

    private Long newOffshoreId;

    /**
     * 线索编号
     */
    private String leadsNo;

    /**
     * 线索名称
     */
    private String leadsName;

    /**
     * 线索状态
     */
    private String leadsStatus;

    /**
     * 线索阶段
     */
    private String leadsStage;

    /**
     * 来源类型
     */
    private String sourceType;


    /**
     * 市场活动
     */
    private PrjProjectPayload market;

    /**
     * 销售负责人
     */
    private Long saleUserId;

    /**
     * 上一任负责人
     */
    private Long preSaleUserId;

    /**
     * 奖金分配对象
     */
    private Long bonusDistributeTo;

    /**
     * 来源人
     */
    private Long sourceUserId;

    /**
     * 市场活动项目id
     */
    private Long marketId;

    /**
     * 渠道
     */
    private String channel;

//    /**
//     * 销售负责人id
//     */
//    private Long saleUserId;

    /**
     * 奖金分配类型
     */
    private String bonusDistributeType;


    /**
     * 关闭原因
     */
    private String closeReason;


    /**
     * 退回原因
     */
    private String backReason;

    /**
     * 收回原因
     */
    private String withdrawReason;

    /**
     * 转移原因
     */
    private String transferReason;

    /**
     * 分配日期
     */
    private LocalDate distributeDate;


//    /**
//     * 关闭原因
//     */
//    private CrmLeadsCustomerPayload customer;

//    /**
//     * 操作日志表
//     */
//    private List<PrdSystemLogPayload> leadsLogs;

    /**
     * 线索成员表
     */
    private List<CrmLeadsMembersPayload> leadsMembers;

//    /**
//     * 线索跟进表
//     */
//    private List<CrmFollowPayload> leadsFollows;


    /**
     * 潜在客户id
     */
    private Long potentialCustomerId;


    /**
     * 潜在客户转移原因
     */
    private String potentialCustomerTransferReason;

    /**
     * 未跟进提醒时间
     */
    private LocalDateTime notFollowLeadsRemindTime;



//======================客户字段==========================

    /**
     * 客户名称
     */
    private String customerName;

    /**
     * 客户行业
     */
    private String customerIndustry;

    /**
     * 客户级别
     */
    private String customerGrade;

    /**
     * 客户联系人
     */
    private String customerContacts;

    /**
     * 联系人部门
     */
    private String contactsDepartment;

    /**
     * 联系人岗位
     */
    private String contactsPosition;

    /**
     * 联系人电话
     */
    private String contactsPhone;
    private String customerPhone;

    /**
     * 联系人邮箱
     */
    private String customerEmail;

    /**
     * 需求产品
     */
    private String demandProduct;

    /**
     * 需求产品部门
     */
    private Long demandProductOrg;


    /**
     * 市场渠道
     */
    private String marketChannel;

    /**
     * 标签
     */
    private String tagIds;


    /**
     * 年营业额
     */
    private String annualTurnover;
    /**
     * 城市
     */
    private String area;

    /**
     * 客户区域
     */
    private String custRegion;

}
