package com.elitesland.tw.tw5.api.prd.crm.vo;

import com.elitescloud.cloudt.common.base.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @author wangly
 * @Description: 近海选项配置
 * @date 2023/06/06 - 11:38
 */
@Getter
@Setter
public class CrmLeadsOffshoreOptionVO extends BaseViewModel implements Serializable {

    /**
     * 线索编号
     */
    @ApiModelProperty("线索编号")
    private String leadsNo;

    /**
     * 线索名称
     */
    @ApiModelProperty("线索名称")
    private String leadsName;
    /**
     * 客户名称
     */
    @ApiModelProperty("客户名称")
    private String customerName;

    /**
     * 市场活动项目id
     */
    @ApiModelProperty("市场活动项目id")
    private Long marketId;
    /**
     * 市场活动项目名称
     */
    @ApiModelProperty("市场活动项目名称")
    private String projectName;

    /**
     * 需求产品
     */
    @ApiModelProperty("需求产品")
    private String demandProduct;

    /**
     * 需求产品
     */
    @ApiModelProperty("需求产品")
    @UdcName(udcName = "crm:leads_demand_product",codePropName = "demandProduct")
    private String demandProductDesc;

    /**
     * 客户联系人
     */
    @ApiModelProperty("客户联系人")
    private String customerContacts;
    /**
     * 联系人电话
     */
    @ApiModelProperty("联系人电话")
    private String contactsPhone;
    /**
     * 线索阶段
     */
    @ApiModelProperty("线索阶段")
    private String leadsStage;
    @UdcName(udcName = "crm:leads_stage",codePropName = "leadsStage")
    private String leadsStageDesc;

    /**
     * 线索状态
     */
    private String leadsStatus;
    @UdcName(udcName = "crm:leads_status",codePropName = "leadsStatus")
    private String leadsStatusDesc;

    /**
     * 客户级别 todo
     */
    private String customerGrade;
    @UdcName(udcName = "crm:customer_grade",codePropName = "customerGrade")
    private String customerGradeDesc;

    /**
     * 报备时间
     */
    @ApiModelProperty("报备时间")
    private LocalDateTime createTime;


    /**
     * 数量
     */
    @ApiModelProperty("数量")
    private Long count;

    /**
     * 配置选项
     */
    @ApiModelProperty("配置选项")
    private String option;

    /**
     * 所属近海
     */
    @ApiModelProperty("所属近海")
    private String offshoreName;

    /**
     * 近海Id主键
     */
    @ApiModelProperty("近海Id主键")
    private Long offshoreId;

}
