package com.elitesland.tw.tw5.api.prd.crm.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * @Author carl.wang
 * @Description 商机外包费用
 * @Date
 **/

@Data
public class CrmOpportunityOutCostPayload extends TwCommonPayload {
    /**
     * 商机ID
     */
    private Long oppoId;
    /**
     * 序号
     */
    private Integer sortNo;
    /**
     * 激活状态  1 未激活   0 激活
     */
    private String activataStatus;
    /**
     * 审批状态
     */
    private String approvalStatus;
    /**
     * 费用描述
     */
    private String costDesc;
    /**
     * 申请人id
     */
    private Long applyUserId;
    private String applyUserName;


    /**
     * tw4.0商机外包费用ID
     */
    private Long outCostIdV4;

    /**
     * 申请日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate applyDate;

    @ApiModelProperty("流程提交标志")
    private Boolean submit;

    @ApiModelProperty("流程实例ID")
    private String procInstId;

    @ApiModelProperty("流程审批状态")
    private ProcInstStatus procInstStatus;

    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;

    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;


}
