package com.elitesland.tw.tw5.api.prd.system.vo;

import com.elitescloud.cloudt.common.base.BaseViewModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

@Data
public class PrdMessageConfigVO extends BaseViewModel {
    /**
     * 消息编号
     */
    @ApiModelProperty("消息编号")
    private String messageCode;
    /**
     * 消息标题
     */
    @ApiModelProperty("消息标题")
    private String messageTitle;
    /**
     * 消息内容
     */
    @ApiModelProperty("消息内容")
    private String messageContent;
    /**
     * 消息类别
     */
    @ApiModelProperty("消息类别")
    private String contentType;
    /**
     * 消息类别名称
     */
    @ApiModelProperty("消息类别名称")
    private String contentTypeName;
    /**
     * 消息大类
     */
    @ApiModelProperty("消息大类")
    private String contentBigType;

    /**
     * 消息大类名称
     */
    @ApiModelProperty("消息大类名称")
    private String contentBigTypeName;

    /**
     * 发布来源， （以谁的名义发布该条消息，默认是个人）
     */
    @ApiModelProperty("发布来源")
    private String releaseSource;

    /**
     * 发布来源名称， （以谁的名义发布该条消息，默认是个人）
     */
    @ApiModelProperty("发布来源")
    private String releaseSourceName;

    /**
     * 发布来源具体对象， （以谁的名义发布该条消息，个人，系统，组织，角色等，默认是个人）
     */
    private String createSource;
    /**
     * 通知方式
     */
    @ApiModelProperty("通知方式")
    private String noticeWay;

    /**
     * 通知方式名称
     */
    @ApiModelProperty("通知方式")
    private String noticeWayName;

    /**
     * 通知范围
     */
    @ApiModelProperty("通知范围")
    private String noticeScope;

    /**
     * 通知范围名称
     */
    @ApiModelProperty("通知范围名称")
    private String noticeScopeName;

    /**
     * 通知范围的关联项，如果选择角色，部门，个人 提交以','分割id或编号
     */
    @ApiModelProperty("通知资源")
    private String noticeSource;
    /**
     * 抄送通知资源 抄送资源,仅限通知方式：邮件
     */
    @ApiModelProperty("抄送通知资源 抄送资源,仅限通知方式：邮件")
    private String ccSource;
    /**
     * 通知范围的关联项，如果选择角色，部门，个人 提交以','分割id或编号
     */
    @ApiModelProperty("通知资源名称")
    private String noticeSourceName;
    /**
     * 触发方式 定时，业务
     */
    @ApiModelProperty("触发方式")
    private String triggerWay;

    /**
     * 触发方式名称
     */
    @ApiModelProperty("触发方式名称")
    private String triggerWayName;

    /**
     * 定时发布（触发时间表达式）
     */
    @ApiModelProperty("触发时间表达式")
    private String triggerTimeExpression;

    /**
     * 定时发布（单次发布具体时间）
     */
    @ApiModelProperty("定时发布（单次发布具体时间）")
    private LocalDateTime triggerTime;
    /**
     * 表达式说明
     */
    @ApiModelProperty("表达式说明")
    private String expressionExplain;
    /**
     * 消息标签
     */
    @ApiModelProperty("消息标签")
    private String messageTag;

    /**
     * 消息标签名称
     */
    @ApiModelProperty("消息标签")
    private String messageTagName;

    /**
     * 发布状态  0新建,1发布中(循环发布),2已撤回,3已发布
     */
    @ApiModelProperty("发布状态")
    private Integer releaseStatus;
    /**
     * 资源类型  1:运维人员，2:行政管理员
     */
    @ApiModelProperty("资源类型")
    private Integer messageType = 1;
    /**
     * 是否启用  0:启用，1：禁用
     */
    @ApiModelProperty("是否启用")
    private Integer isEnable;

    /**
     * 业务数据id
     */
    private Long objectId;

    /**
     * 业务数据具体业务
     */
    private String action;

    /**
     * 要抄送的邮箱信息，仅限通知方式：邮件 多个已英文逗号隔开
     */
    private String ccEmails;

}
