package com.elitesland.tw.tw5.api.common.change.service;


import com.elitesland.tw.tw5.api.common.change.payload.ComChangeDataPayload;
import com.elitesland.tw.tw5.api.common.change.payload.ComChangePayload;
import com.elitesland.tw.tw5.api.common.change.query.ComChangeQuery;
import com.elitesland.tw.tw5.api.common.change.vo.ComChangeVO;

import java.util.List;

/**
 * @author carl
 */
public interface ComChangeService {

    /**
     * 通用变更数据保存
     *
     * @param payload
     * @return
     */
    ComChangeVO insert(ComChangePayload payload);

    /**
     * 通用变更数据保存
     *
     * @param changeType    变更类型
     * @param originalModel 原始数据
     * @param changeModel   变更后数据
     * @param docId         变更单据id
     * @return 变更后数据主键
     */
    Long save(String changeType, Object originalModel, Object changeModel, String docId);

    /**
     * 通用变更数据保存
     *
     * @return 变更后数据主键
     */
    Long save(ComChangeDataPayload changeDataPayload);

    /**
     * 通用变更数据的更新
     *
     * @param changeType  变更类型
     * @param changeModel 变更好数据
     * @param docId       数据源id
     * @return
     */
    Long update(String changeType, String docId, Object changeModel);

    /**
     * 条件查询 变更历史
     *
     * @param query 条件查询对象
     * @return 变更历史数组
     */
    List<ComChangeVO> changeSearch(ComChangeQuery query);

    /**
     * 数据比对
     *
     * @param id        比对目标数据id
     * @param compareId 比对数据id
     * @return dataStatus 1:表示被删除的数据，2：表示新增数据
     */
    Object getCompareChange(Long id, Long compareId);

    /**
     * 变更审批状态
     *
     * @param payload
     * @return
     */
    Long updateWorkFlow(ComChangePayload payload);

    /**
     * 主键查询
     *
     * @param key
     * @return
     */
    ComChangeVO queryByKey(Long key);
}
