package com.elitesland.tw.tw5.api.prd.crm.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.common.annotation.Query;
import lombok.Data;

import java.util.List;

/**
 * 人脉经营-经营机会点
 *
 * @author carl
 * @date 2022/11/21
 */
@Data
public class CrmCustomerOperationChanceQuery extends TwQueryParam {

    /**
     * 客户经营主键
     */
    @Query
    private Long operId;
    /**
     * 跟踪人
     */
    private Long trackerUserId;
    /**
     * 标题
     */
    private String title;
    /**
     * 客户经营名称
     */
    private String custName;
    /*
     *是否已读
     */
    private Integer isRead;
    /**
     * 不需要权限
     */
    private Boolean noPermissionFlag = false;
    /**
     * 拥有的客户经营权限ids
     */
    private List<Long> operationIds;

    /**
     * 客户经营部门
     */
    private Long custOperBu;

    /**
     * 客户经营部负责人
     */
    private Long custOperManagerId;

    /**
     * 销售经营部门
     */
    private Long saleOperBu;

    /**
     * 销售经营部负责人
     */
    private Long saleOperManagerId;

    /**
     * 知会人
     */
    private String informUserIds;

    /**
     * 参与人
     */
    private String involvedUserIds;

    /**
     * 预计时间年份
     */
    private Integer expectYear;
    /**
     * 预计时间季度
     */
    private Integer expectQuarter;
}
